# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ProfileWithDateRange
    from . import UserReference

class UserProfilesInDateRange(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserProfilesInDateRange - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user': 'UserReference',
            'date_start_workday': 'date',
            'date_end_workday': 'date',
            'profiles': 'list[ProfileWithDateRange]'
        }

        self.attribute_map = {
            'user': 'user',
            'date_start_workday': 'dateStartWorkday',
            'date_end_workday': 'dateEndWorkday',
            'profiles': 'profiles'
        }

        self._user = None
        self._date_start_workday = None
        self._date_end_workday = None
        self._profiles = None

    @property
    def user(self) -> 'UserReference':
        """
        Gets the user of this UserProfilesInDateRange.
        The query agent

        :return: The user of this UserProfilesInDateRange.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'UserReference') -> None:
        """
        Sets the user of this UserProfilesInDateRange.
        The query agent

        :param user: The user of this UserProfilesInDateRange.
        :type: UserReference
        """
        

        self._user = user

    @property
    def date_start_workday(self) -> date:
        """
        Gets the date_start_workday of this UserProfilesInDateRange.
        Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start_workday of this UserProfilesInDateRange.
        :rtype: date
        """
        return self._date_start_workday

    @date_start_workday.setter
    def date_start_workday(self, date_start_workday: date) -> None:
        """
        Sets the date_start_workday of this UserProfilesInDateRange.
        Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start_workday: The date_start_workday of this UserProfilesInDateRange.
        :type: date
        """
        

        self._date_start_workday = date_start_workday

    @property
    def date_end_workday(self) -> date:
        """
        Gets the date_end_workday of this UserProfilesInDateRange.
        End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end_workday of this UserProfilesInDateRange.
        :rtype: date
        """
        return self._date_end_workday

    @date_end_workday.setter
    def date_end_workday(self, date_end_workday: date) -> None:
        """
        Sets the date_end_workday of this UserProfilesInDateRange.
        End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end_workday: The date_end_workday of this UserProfilesInDateRange.
        :type: date
        """
        

        self._date_end_workday = date_end_workday

    @property
    def profiles(self) -> List['ProfileWithDateRange']:
        """
        Gets the profiles of this UserProfilesInDateRange.
        The list of profiles of the agent

        :return: The profiles of this UserProfilesInDateRange.
        :rtype: list[ProfileWithDateRange]
        """
        return self._profiles

    @profiles.setter
    def profiles(self, profiles: List['ProfileWithDateRange']) -> None:
        """
        Sets the profiles of this UserProfilesInDateRange.
        The list of profiles of the agent

        :param profiles: The profiles of this UserProfilesInDateRange.
        :type: list[ProfileWithDateRange]
        """
        

        self._profiles = profiles

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

