# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import DivisionReference
    from . import UserInsightsTrendMetricItem
    from . import UserInsightsTrendTotalItem
    from . import UserReference
    from . import WorkdayPeriod

class UserInsightsTrend(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserInsightsTrend - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'performance_profile': 'AddressableEntityRef',
            'division': 'DivisionReference',
            'granularity': 'str',
            'comparative_period': 'WorkdayPeriod',
            'primary_period': 'WorkdayPeriod',
            'user': 'UserReference',
            'entities': 'list[UserInsightsTrendMetricItem]',
            'total': 'UserInsightsTrendTotalItem'
        }

        self.attribute_map = {
            'performance_profile': 'performanceProfile',
            'division': 'division',
            'granularity': 'granularity',
            'comparative_period': 'comparativePeriod',
            'primary_period': 'primaryPeriod',
            'user': 'user',
            'entities': 'entities',
            'total': 'total'
        }

        self._performance_profile = None
        self._division = None
        self._granularity = None
        self._comparative_period = None
        self._primary_period = None
        self._user = None
        self._entities = None
        self._total = None

    @property
    def performance_profile(self) -> 'AddressableEntityRef':
        """
        Gets the performance_profile of this UserInsightsTrend.
        The performance profile

        :return: The performance_profile of this UserInsightsTrend.
        :rtype: AddressableEntityRef
        """
        return self._performance_profile

    @performance_profile.setter
    def performance_profile(self, performance_profile: 'AddressableEntityRef') -> None:
        """
        Sets the performance_profile of this UserInsightsTrend.
        The performance profile

        :param performance_profile: The performance_profile of this UserInsightsTrend.
        :type: AddressableEntityRef
        """
        

        self._performance_profile = performance_profile

    @property
    def division(self) -> 'DivisionReference':
        """
        Gets the division of this UserInsightsTrend.
        The division

        :return: The division of this UserInsightsTrend.
        :rtype: DivisionReference
        """
        return self._division

    @division.setter
    def division(self, division: 'DivisionReference') -> None:
        """
        Sets the division of this UserInsightsTrend.
        The division

        :param division: The division of this UserInsightsTrend.
        :type: DivisionReference
        """
        

        self._division = division

    @property
    def granularity(self) -> str:
        """
        Gets the granularity of this UserInsightsTrend.
        Granularity

        :return: The granularity of this UserInsightsTrend.
        :rtype: str
        """
        return self._granularity

    @granularity.setter
    def granularity(self, granularity: str) -> None:
        """
        Sets the granularity of this UserInsightsTrend.
        Granularity

        :param granularity: The granularity of this UserInsightsTrend.
        :type: str
        """
        if isinstance(granularity, int):
            granularity = str(granularity)
        allowed_values = ["Daily", "Weekly", "Monthly"]
        if granularity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for granularity -> " + granularity)
            self._granularity = "outdated_sdk_version"
        else:
            self._granularity = granularity

    @property
    def comparative_period(self) -> 'WorkdayPeriod':
        """
        Gets the comparative_period of this UserInsightsTrend.
        The comparative period work day date range

        :return: The comparative_period of this UserInsightsTrend.
        :rtype: WorkdayPeriod
        """
        return self._comparative_period

    @comparative_period.setter
    def comparative_period(self, comparative_period: 'WorkdayPeriod') -> None:
        """
        Sets the comparative_period of this UserInsightsTrend.
        The comparative period work day date range

        :param comparative_period: The comparative_period of this UserInsightsTrend.
        :type: WorkdayPeriod
        """
        

        self._comparative_period = comparative_period

    @property
    def primary_period(self) -> 'WorkdayPeriod':
        """
        Gets the primary_period of this UserInsightsTrend.
        The primary period work day date range

        :return: The primary_period of this UserInsightsTrend.
        :rtype: WorkdayPeriod
        """
        return self._primary_period

    @primary_period.setter
    def primary_period(self, primary_period: 'WorkdayPeriod') -> None:
        """
        Sets the primary_period of this UserInsightsTrend.
        The primary period work day date range

        :param primary_period: The primary_period of this UserInsightsTrend.
        :type: WorkdayPeriod
        """
        

        self._primary_period = primary_period

    @property
    def user(self) -> 'UserReference':
        """
        Gets the user of this UserInsightsTrend.
        The query user

        :return: The user of this UserInsightsTrend.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'UserReference') -> None:
        """
        Sets the user of this UserInsightsTrend.
        The query user

        :param user: The user of this UserInsightsTrend.
        :type: UserReference
        """
        

        self._user = user

    @property
    def entities(self) -> List['UserInsightsTrendMetricItem']:
        """
        Gets the entities of this UserInsightsTrend.
        The list of insights trend for each metric

        :return: The entities of this UserInsightsTrend.
        :rtype: list[UserInsightsTrendMetricItem]
        """
        return self._entities

    @entities.setter
    def entities(self, entities: List['UserInsightsTrendMetricItem']) -> None:
        """
        Sets the entities of this UserInsightsTrend.
        The list of insights trend for each metric

        :param entities: The entities of this UserInsightsTrend.
        :type: list[UserInsightsTrendMetricItem]
        """
        

        self._entities = entities

    @property
    def total(self) -> 'UserInsightsTrendTotalItem':
        """
        Gets the total of this UserInsightsTrend.
        The insights trend in total

        :return: The total of this UserInsightsTrend.
        :rtype: UserInsightsTrendTotalItem
        """
        return self._total

    @total.setter
    def total(self, total: 'UserInsightsTrendTotalItem') -> None:
        """
        Sets the total of this UserInsightsTrend.
        The insights trend in total

        :param total: The total of this UserInsightsTrend.
        :type: UserInsightsTrendTotalItem
        """
        

        self._total = total

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

