# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserConversationsEventMediaSummary

class UserConversationsEventUserConversationSummary(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserConversationsEventUserConversationSummary - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user_id': 'str',
            'call': 'UserConversationsEventMediaSummary',
            'callback': 'UserConversationsEventMediaSummary',
            'email': 'UserConversationsEventMediaSummary',
            'message': 'UserConversationsEventMediaSummary',
            'chat': 'UserConversationsEventMediaSummary',
            'social_expression': 'UserConversationsEventMediaSummary',
            'video': 'UserConversationsEventMediaSummary'
        }

        self.attribute_map = {
            'user_id': 'userId',
            'call': 'call',
            'callback': 'callback',
            'email': 'email',
            'message': 'message',
            'chat': 'chat',
            'social_expression': 'socialExpression',
            'video': 'video'
        }

        self._user_id = None
        self._call = None
        self._callback = None
        self._email = None
        self._message = None
        self._chat = None
        self._social_expression = None
        self._video = None

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this UserConversationsEventUserConversationSummary.


        :return: The user_id of this UserConversationsEventUserConversationSummary.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this UserConversationsEventUserConversationSummary.


        :param user_id: The user_id of this UserConversationsEventUserConversationSummary.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def call(self) -> 'UserConversationsEventMediaSummary':
        """
        Gets the call of this UserConversationsEventUserConversationSummary.


        :return: The call of this UserConversationsEventUserConversationSummary.
        :rtype: UserConversationsEventMediaSummary
        """
        return self._call

    @call.setter
    def call(self, call: 'UserConversationsEventMediaSummary') -> None:
        """
        Sets the call of this UserConversationsEventUserConversationSummary.


        :param call: The call of this UserConversationsEventUserConversationSummary.
        :type: UserConversationsEventMediaSummary
        """
        

        self._call = call

    @property
    def callback(self) -> 'UserConversationsEventMediaSummary':
        """
        Gets the callback of this UserConversationsEventUserConversationSummary.


        :return: The callback of this UserConversationsEventUserConversationSummary.
        :rtype: UserConversationsEventMediaSummary
        """
        return self._callback

    @callback.setter
    def callback(self, callback: 'UserConversationsEventMediaSummary') -> None:
        """
        Sets the callback of this UserConversationsEventUserConversationSummary.


        :param callback: The callback of this UserConversationsEventUserConversationSummary.
        :type: UserConversationsEventMediaSummary
        """
        

        self._callback = callback

    @property
    def email(self) -> 'UserConversationsEventMediaSummary':
        """
        Gets the email of this UserConversationsEventUserConversationSummary.


        :return: The email of this UserConversationsEventUserConversationSummary.
        :rtype: UserConversationsEventMediaSummary
        """
        return self._email

    @email.setter
    def email(self, email: 'UserConversationsEventMediaSummary') -> None:
        """
        Sets the email of this UserConversationsEventUserConversationSummary.


        :param email: The email of this UserConversationsEventUserConversationSummary.
        :type: UserConversationsEventMediaSummary
        """
        

        self._email = email

    @property
    def message(self) -> 'UserConversationsEventMediaSummary':
        """
        Gets the message of this UserConversationsEventUserConversationSummary.


        :return: The message of this UserConversationsEventUserConversationSummary.
        :rtype: UserConversationsEventMediaSummary
        """
        return self._message

    @message.setter
    def message(self, message: 'UserConversationsEventMediaSummary') -> None:
        """
        Sets the message of this UserConversationsEventUserConversationSummary.


        :param message: The message of this UserConversationsEventUserConversationSummary.
        :type: UserConversationsEventMediaSummary
        """
        

        self._message = message

    @property
    def chat(self) -> 'UserConversationsEventMediaSummary':
        """
        Gets the chat of this UserConversationsEventUserConversationSummary.


        :return: The chat of this UserConversationsEventUserConversationSummary.
        :rtype: UserConversationsEventMediaSummary
        """
        return self._chat

    @chat.setter
    def chat(self, chat: 'UserConversationsEventMediaSummary') -> None:
        """
        Sets the chat of this UserConversationsEventUserConversationSummary.


        :param chat: The chat of this UserConversationsEventUserConversationSummary.
        :type: UserConversationsEventMediaSummary
        """
        

        self._chat = chat

    @property
    def social_expression(self) -> 'UserConversationsEventMediaSummary':
        """
        Gets the social_expression of this UserConversationsEventUserConversationSummary.


        :return: The social_expression of this UserConversationsEventUserConversationSummary.
        :rtype: UserConversationsEventMediaSummary
        """
        return self._social_expression

    @social_expression.setter
    def social_expression(self, social_expression: 'UserConversationsEventMediaSummary') -> None:
        """
        Sets the social_expression of this UserConversationsEventUserConversationSummary.


        :param social_expression: The social_expression of this UserConversationsEventUserConversationSummary.
        :type: UserConversationsEventMediaSummary
        """
        

        self._social_expression = social_expression

    @property
    def video(self) -> 'UserConversationsEventMediaSummary':
        """
        Gets the video of this UserConversationsEventUserConversationSummary.


        :return: The video of this UserConversationsEventUserConversationSummary.
        :rtype: UserConversationsEventMediaSummary
        """
        return self._video

    @video.setter
    def video(self, video: 'UserConversationsEventMediaSummary') -> None:
        """
        Sets the video of this UserConversationsEventUserConversationSummary.


        :param video: The video of this UserConversationsEventUserConversationSummary.
        :type: UserConversationsEventMediaSummary
        """
        

        self._video = video

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

