# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class UserActivityEntityData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserActivityEntityData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'activity_date': 'datetime',
            'organization_presence_id': 'str',
            'presence_date': 'datetime',
            'queue_id': 'str',
            'queue_membership_status': 'str',
            'routing_status': 'str',
            'routing_status_date': 'datetime',
            'system_presence': 'str',
            'team_id': 'str',
            'user_id': 'str'
        }

        self.attribute_map = {
            'activity_date': 'activityDate',
            'organization_presence_id': 'organizationPresenceId',
            'presence_date': 'presenceDate',
            'queue_id': 'queueId',
            'queue_membership_status': 'queueMembershipStatus',
            'routing_status': 'routingStatus',
            'routing_status_date': 'routingStatusDate',
            'system_presence': 'systemPresence',
            'team_id': 'teamId',
            'user_id': 'userId'
        }

        self._activity_date = None
        self._organization_presence_id = None
        self._presence_date = None
        self._queue_id = None
        self._queue_membership_status = None
        self._routing_status = None
        self._routing_status_date = None
        self._system_presence = None
        self._team_id = None
        self._user_id = None

    @property
    def activity_date(self) -> datetime:
        """
        Gets the activity_date of this UserActivityEntityData.
        The time at which the activity was observed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The activity_date of this UserActivityEntityData.
        :rtype: datetime
        """
        return self._activity_date

    @activity_date.setter
    def activity_date(self, activity_date: datetime) -> None:
        """
        Sets the activity_date of this UserActivityEntityData.
        The time at which the activity was observed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param activity_date: The activity_date of this UserActivityEntityData.
        :type: datetime
        """
        

        self._activity_date = activity_date

    @property
    def organization_presence_id(self) -> str:
        """
        Gets the organization_presence_id of this UserActivityEntityData.
        Organization presence identifier

        :return: The organization_presence_id of this UserActivityEntityData.
        :rtype: str
        """
        return self._organization_presence_id

    @organization_presence_id.setter
    def organization_presence_id(self, organization_presence_id: str) -> None:
        """
        Sets the organization_presence_id of this UserActivityEntityData.
        Organization presence identifier

        :param organization_presence_id: The organization_presence_id of this UserActivityEntityData.
        :type: str
        """
        

        self._organization_presence_id = organization_presence_id

    @property
    def presence_date(self) -> datetime:
        """
        Gets the presence_date of this UserActivityEntityData.
        Date of the latest presence change. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The presence_date of this UserActivityEntityData.
        :rtype: datetime
        """
        return self._presence_date

    @presence_date.setter
    def presence_date(self, presence_date: datetime) -> None:
        """
        Sets the presence_date of this UserActivityEntityData.
        Date of the latest presence change. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param presence_date: The presence_date of this UserActivityEntityData.
        :type: datetime
        """
        

        self._presence_date = presence_date

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this UserActivityEntityData.
        Queue identifier

        :return: The queue_id of this UserActivityEntityData.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this UserActivityEntityData.
        Queue identifier

        :param queue_id: The queue_id of this UserActivityEntityData.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def queue_membership_status(self) -> str:
        """
        Gets the queue_membership_status of this UserActivityEntityData.
        Queue membership status (e.g. active or inactive)

        :return: The queue_membership_status of this UserActivityEntityData.
        :rtype: str
        """
        return self._queue_membership_status

    @queue_membership_status.setter
    def queue_membership_status(self, queue_membership_status: str) -> None:
        """
        Sets the queue_membership_status of this UserActivityEntityData.
        Queue membership status (e.g. active or inactive)

        :param queue_membership_status: The queue_membership_status of this UserActivityEntityData.
        :type: str
        """
        

        self._queue_membership_status = queue_membership_status

    @property
    def routing_status(self) -> str:
        """
        Gets the routing_status of this UserActivityEntityData.
        Agent routing status

        :return: The routing_status of this UserActivityEntityData.
        :rtype: str
        """
        return self._routing_status

    @routing_status.setter
    def routing_status(self, routing_status: str) -> None:
        """
        Sets the routing_status of this UserActivityEntityData.
        Agent routing status

        :param routing_status: The routing_status of this UserActivityEntityData.
        :type: str
        """
        

        self._routing_status = routing_status

    @property
    def routing_status_date(self) -> datetime:
        """
        Gets the routing_status_date of this UserActivityEntityData.
        Date of the latest routing status change. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The routing_status_date of this UserActivityEntityData.
        :rtype: datetime
        """
        return self._routing_status_date

    @routing_status_date.setter
    def routing_status_date(self, routing_status_date: datetime) -> None:
        """
        Sets the routing_status_date of this UserActivityEntityData.
        Date of the latest routing status change. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param routing_status_date: The routing_status_date of this UserActivityEntityData.
        :type: datetime
        """
        

        self._routing_status_date = routing_status_date

    @property
    def system_presence(self) -> str:
        """
        Gets the system_presence of this UserActivityEntityData.
        System presence

        :return: The system_presence of this UserActivityEntityData.
        :rtype: str
        """
        return self._system_presence

    @system_presence.setter
    def system_presence(self, system_presence: str) -> None:
        """
        Sets the system_presence of this UserActivityEntityData.
        System presence

        :param system_presence: The system_presence of this UserActivityEntityData.
        :type: str
        """
        

        self._system_presence = system_presence

    @property
    def team_id(self) -> str:
        """
        Gets the team_id of this UserActivityEntityData.
        The team ID the user is a member of

        :return: The team_id of this UserActivityEntityData.
        :rtype: str
        """
        return self._team_id

    @team_id.setter
    def team_id(self, team_id: str) -> None:
        """
        Sets the team_id of this UserActivityEntityData.
        The team ID the user is a member of

        :param team_id: The team_id of this UserActivityEntityData.
        :type: str
        """
        

        self._team_id = team_id

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this UserActivityEntityData.
        Unique identifier for the user

        :return: The user_id of this UserActivityEntityData.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this UserActivityEntityData.
        Unique identifier for the user

        :param user_id: The user_id of this UserActivityEntityData.
        :type: str
        """
        

        self._user_id = user_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

