# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BuShortTermForecastWeekReference
    from . import ListWrapperAgentWorkPlanField

class UpdateWorkPlanBid(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UpdateWorkPlanBid - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'forecast': 'BuShortTermForecastWeekReference',
            'bid_window_start_date': 'date',
            'bid_window_end_date': 'date',
            'effective_date': 'date',
            'agent_ranking_type': 'str',
            'ranking_tiebreaker_type': 'str',
            'work_plan_fields_visible_to_agents': 'ListWrapperAgentWorkPlanField',
            'status': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'forecast': 'forecast',
            'bid_window_start_date': 'bidWindowStartDate',
            'bid_window_end_date': 'bidWindowEndDate',
            'effective_date': 'effectiveDate',
            'agent_ranking_type': 'agentRankingType',
            'ranking_tiebreaker_type': 'rankingTiebreakerType',
            'work_plan_fields_visible_to_agents': 'workPlanFieldsVisibleToAgents',
            'status': 'status'
        }

        self._name = None
        self._forecast = None
        self._bid_window_start_date = None
        self._bid_window_end_date = None
        self._effective_date = None
        self._agent_ranking_type = None
        self._ranking_tiebreaker_type = None
        self._work_plan_fields_visible_to_agents = None
        self._status = None

    @property
    def name(self) -> str:
        """
        Gets the name of this UpdateWorkPlanBid.
        The name of the work plan bid

        :return: The name of this UpdateWorkPlanBid.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this UpdateWorkPlanBid.
        The name of the work plan bid

        :param name: The name of this UpdateWorkPlanBid.
        :type: str
        """
        

        self._name = name

    @property
    def forecast(self) -> 'BuShortTermForecastWeekReference':
        """
        Gets the forecast of this UpdateWorkPlanBid.
        The selected forecast in this work plan bid

        :return: The forecast of this UpdateWorkPlanBid.
        :rtype: BuShortTermForecastWeekReference
        """
        return self._forecast

    @forecast.setter
    def forecast(self, forecast: 'BuShortTermForecastWeekReference') -> None:
        """
        Sets the forecast of this UpdateWorkPlanBid.
        The selected forecast in this work plan bid

        :param forecast: The forecast of this UpdateWorkPlanBid.
        :type: BuShortTermForecastWeekReference
        """
        

        self._forecast = forecast

    @property
    def bid_window_start_date(self) -> date:
        """
        Gets the bid_window_start_date of this UpdateWorkPlanBid.
        The bid start date where agents start participate in work plan bidding in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The bid_window_start_date of this UpdateWorkPlanBid.
        :rtype: date
        """
        return self._bid_window_start_date

    @bid_window_start_date.setter
    def bid_window_start_date(self, bid_window_start_date: date) -> None:
        """
        Sets the bid_window_start_date of this UpdateWorkPlanBid.
        The bid start date where agents start participate in work plan bidding in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param bid_window_start_date: The bid_window_start_date of this UpdateWorkPlanBid.
        :type: date
        """
        

        self._bid_window_start_date = bid_window_start_date

    @property
    def bid_window_end_date(self) -> date:
        """
        Gets the bid_window_end_date of this UpdateWorkPlanBid.
        The bid end date in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The bid_window_end_date of this UpdateWorkPlanBid.
        :rtype: date
        """
        return self._bid_window_end_date

    @bid_window_end_date.setter
    def bid_window_end_date(self, bid_window_end_date: date) -> None:
        """
        Sets the bid_window_end_date of this UpdateWorkPlanBid.
        The bid end date in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param bid_window_end_date: The bid_window_end_date of this UpdateWorkPlanBid.
        :type: date
        """
        

        self._bid_window_end_date = bid_window_end_date

    @property
    def effective_date(self) -> date:
        """
        Gets the effective_date of this UpdateWorkPlanBid.
        The date when agents will be assigned to the new work plan in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The effective_date of this UpdateWorkPlanBid.
        :rtype: date
        """
        return self._effective_date

    @effective_date.setter
    def effective_date(self, effective_date: date) -> None:
        """
        Sets the effective_date of this UpdateWorkPlanBid.
        The date when agents will be assigned to the new work plan in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param effective_date: The effective_date of this UpdateWorkPlanBid.
        :type: date
        """
        

        self._effective_date = effective_date

    @property
    def agent_ranking_type(self) -> str:
        """
        Gets the agent_ranking_type of this UpdateWorkPlanBid.
        The type of agent ranking selected for this bid

        :return: The agent_ranking_type of this UpdateWorkPlanBid.
        :rtype: str
        """
        return self._agent_ranking_type

    @agent_ranking_type.setter
    def agent_ranking_type(self, agent_ranking_type: str) -> None:
        """
        Sets the agent_ranking_type of this UpdateWorkPlanBid.
        The type of agent ranking selected for this bid

        :param agent_ranking_type: The agent_ranking_type of this UpdateWorkPlanBid.
        :type: str
        """
        if isinstance(agent_ranking_type, int):
            agent_ranking_type = str(agent_ranking_type)
        allowed_values = ["HireDate", "Performance"]
        if agent_ranking_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for agent_ranking_type -> " + agent_ranking_type)
            self._agent_ranking_type = "outdated_sdk_version"
        else:
            self._agent_ranking_type = agent_ranking_type

    @property
    def ranking_tiebreaker_type(self) -> str:
        """
        Gets the ranking_tiebreaker_type of this UpdateWorkPlanBid.
        Ranking tiebreaker

        :return: The ranking_tiebreaker_type of this UpdateWorkPlanBid.
        :rtype: str
        """
        return self._ranking_tiebreaker_type

    @ranking_tiebreaker_type.setter
    def ranking_tiebreaker_type(self, ranking_tiebreaker_type: str) -> None:
        """
        Sets the ranking_tiebreaker_type of this UpdateWorkPlanBid.
        Ranking tiebreaker

        :param ranking_tiebreaker_type: The ranking_tiebreaker_type of this UpdateWorkPlanBid.
        :type: str
        """
        if isinstance(ranking_tiebreaker_type, int):
            ranking_tiebreaker_type = str(ranking_tiebreaker_type)
        allowed_values = ["HireDate", "Performance", "Custom", "RandomlyAssign"]
        if ranking_tiebreaker_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for ranking_tiebreaker_type -> " + ranking_tiebreaker_type)
            self._ranking_tiebreaker_type = "outdated_sdk_version"
        else:
            self._ranking_tiebreaker_type = ranking_tiebreaker_type

    @property
    def work_plan_fields_visible_to_agents(self) -> 'ListWrapperAgentWorkPlanField':
        """
        Gets the work_plan_fields_visible_to_agents of this UpdateWorkPlanBid.
        The work plan fields visible to agents whenever work plan preferences are made

        :return: The work_plan_fields_visible_to_agents of this UpdateWorkPlanBid.
        :rtype: ListWrapperAgentWorkPlanField
        """
        return self._work_plan_fields_visible_to_agents

    @work_plan_fields_visible_to_agents.setter
    def work_plan_fields_visible_to_agents(self, work_plan_fields_visible_to_agents: 'ListWrapperAgentWorkPlanField') -> None:
        """
        Sets the work_plan_fields_visible_to_agents of this UpdateWorkPlanBid.
        The work plan fields visible to agents whenever work plan preferences are made

        :param work_plan_fields_visible_to_agents: The work_plan_fields_visible_to_agents of this UpdateWorkPlanBid.
        :type: ListWrapperAgentWorkPlanField
        """
        

        self._work_plan_fields_visible_to_agents = work_plan_fields_visible_to_agents

    @property
    def status(self) -> str:
        """
        Gets the status of this UpdateWorkPlanBid.
        The state of the bid

        :return: The status of this UpdateWorkPlanBid.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this UpdateWorkPlanBid.
        The state of the bid

        :param status: The status of this UpdateWorkPlanBid.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Draft", "Locked", "Optimized", "Scheduled", "Open", "Closed", "Processed", "Published"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

