# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserReference

class UpdateMuAgentWorkPlanFailureResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UpdateMuAgentWorkPlanFailureResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user': 'UserReference',
            'failure': 'str',
            'not_found_work_plan_id': 'str'
        }

        self.attribute_map = {
            'user': 'user',
            'failure': 'failure',
            'not_found_work_plan_id': 'notFoundWorkPlanId'
        }

        self._user = None
        self._failure = None
        self._not_found_work_plan_id = None

    @property
    def user(self) -> 'UserReference':
        """
        Gets the user of this UpdateMuAgentWorkPlanFailureResponse.
        The user for whom the work plan update has failed

        :return: The user of this UpdateMuAgentWorkPlanFailureResponse.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'UserReference') -> None:
        """
        Sets the user of this UpdateMuAgentWorkPlanFailureResponse.
        The user for whom the work plan update has failed

        :param user: The user of this UpdateMuAgentWorkPlanFailureResponse.
        :type: UserReference
        """
        

        self._user = user

    @property
    def failure(self) -> str:
        """
        Gets the failure of this UpdateMuAgentWorkPlanFailureResponse.
        The work plan update failure reason

        :return: The failure of this UpdateMuAgentWorkPlanFailureResponse.
        :rtype: str
        """
        return self._failure

    @failure.setter
    def failure(self, failure: str) -> None:
        """
        Sets the failure of this UpdateMuAgentWorkPlanFailureResponse.
        The work plan update failure reason

        :param failure: The failure of this UpdateMuAgentWorkPlanFailureResponse.
        :type: str
        """
        if isinstance(failure, int):
            failure = str(failure)
        allowed_values = ["AgentNotInManagementUnit", "OverlappingOverride", "OverrideNotFound", "TooManyOverrides", "WorkPlanNotFound"]
        if failure.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for failure -> " + failure)
            self._failure = "outdated_sdk_version"
        else:
            self._failure = failure

    @property
    def not_found_work_plan_id(self) -> str:
        """
        Gets the not_found_work_plan_id of this UpdateMuAgentWorkPlanFailureResponse.
        The id of the work plan that has not been found

        :return: The not_found_work_plan_id of this UpdateMuAgentWorkPlanFailureResponse.
        :rtype: str
        """
        return self._not_found_work_plan_id

    @not_found_work_plan_id.setter
    def not_found_work_plan_id(self, not_found_work_plan_id: str) -> None:
        """
        Sets the not_found_work_plan_id of this UpdateMuAgentWorkPlanFailureResponse.
        The id of the work plan that has not been found

        :param not_found_work_plan_id: The not_found_work_plan_id of this UpdateMuAgentWorkPlanFailureResponse.
        :type: str
        """
        

        self._not_found_work_plan_id = not_found_work_plan_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

