# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class TwitterSignupOAuthSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TwitterSignupOAuthSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'client_id': 'str',
            'scopes': 'list[str]',
            'app_id': 'str'
        }

        self.attribute_map = {
            'client_id': 'clientId',
            'scopes': 'scopes',
            'app_id': 'appId'
        }

        self._client_id = None
        self._scopes = None
        self._app_id = None

    @property
    def client_id(self) -> str:
        """
        Gets the client_id of this TwitterSignupOAuthSettings.
        The client id of the twitter app the requesting org will use to signup

        :return: The client_id of this TwitterSignupOAuthSettings.
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id: str) -> None:
        """
        Sets the client_id of this TwitterSignupOAuthSettings.
        The client id of the twitter app the requesting org will use to signup

        :param client_id: The client_id of this TwitterSignupOAuthSettings.
        :type: str
        """
        

        self._client_id = client_id

    @property
    def scopes(self) -> List[str]:
        """
        Gets the scopes of this TwitterSignupOAuthSettings.
        The scopes/permissions requested during the signup process during the signup process to allow their future integrations to direct message

        :return: The scopes of this TwitterSignupOAuthSettings.
        :rtype: list[str]
        """
        return self._scopes

    @scopes.setter
    def scopes(self, scopes: List[str]) -> None:
        """
        Sets the scopes of this TwitterSignupOAuthSettings.
        The scopes/permissions requested during the signup process during the signup process to allow their future integrations to direct message

        :param scopes: The scopes of this TwitterSignupOAuthSettings.
        :type: list[str]
        """
        

        self._scopes = scopes

    @property
    def app_id(self) -> str:
        """
        Gets the app_id of this TwitterSignupOAuthSettings.
        The app id of the twitter app the requesting org will use to signup

        :return: The app_id of this TwitterSignupOAuthSettings.
        :rtype: str
        """
        return self._app_id

    @app_id.setter
    def app_id(self, app_id: str) -> None:
        """
        Sets the app_id of this TwitterSignupOAuthSettings.
        The app id of the twitter app the requesting org will use to signup

        :param app_id: The app_id of this TwitterSignupOAuthSettings.
        :type: str
        """
        

        self._app_id = app_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

