# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class TwitterDataIngestionRuleRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TwitterDataIngestionRuleRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'search_terms': 'str',
            'countries': 'list[str]'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'search_terms': 'searchTerms',
            'countries': 'countries'
        }

        self._name = None
        self._description = None
        self._search_terms = None
        self._countries = None

    @property
    def name(self) -> str:
        """
        Gets the name of this TwitterDataIngestionRuleRequest.
        The name of the data ingestion rule.

        :return: The name of this TwitterDataIngestionRuleRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this TwitterDataIngestionRuleRequest.
        The name of the data ingestion rule.

        :param name: The name of this TwitterDataIngestionRuleRequest.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this TwitterDataIngestionRuleRequest.
        A description of the data ingestion rule.

        :return: The description of this TwitterDataIngestionRuleRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this TwitterDataIngestionRuleRequest.
        A description of the data ingestion rule.

        :param description: The description of this TwitterDataIngestionRuleRequest.
        :type: str
        """
        

        self._description = description

    @property
    def search_terms(self) -> str:
        """
        Gets the search_terms of this TwitterDataIngestionRuleRequest.
        Search terms for X (formally Twitter).

        :return: The search_terms of this TwitterDataIngestionRuleRequest.
        :rtype: str
        """
        return self._search_terms

    @search_terms.setter
    def search_terms(self, search_terms: str) -> None:
        """
        Sets the search_terms of this TwitterDataIngestionRuleRequest.
        Search terms for X (formally Twitter).

        :param search_terms: The search_terms of this TwitterDataIngestionRuleRequest.
        :type: str
        """
        

        self._search_terms = search_terms

    @property
    def countries(self) -> List[str]:
        """
        Gets the countries of this TwitterDataIngestionRuleRequest.
        ISO 3166-1 alpha-2 country codes. Ingestion of matching tweets will be restricted to tweets posted in the countries specified here. Defaults to worldwide.

        :return: The countries of this TwitterDataIngestionRuleRequest.
        :rtype: list[str]
        """
        return self._countries

    @countries.setter
    def countries(self, countries: List[str]) -> None:
        """
        Sets the countries of this TwitterDataIngestionRuleRequest.
        ISO 3166-1 alpha-2 country codes. Ingestion of matching tweets will be restricted to tweets posted in the countries specified here. Defaults to worldwide.

        :param countries: The countries of this TwitterDataIngestionRuleRequest.
        :type: list[str]
        """
        

        self._countries = countries

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

