# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class TweetUsage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TweetUsage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'ingestion_limit': 'int',
            'tweet_count': 'int',
            'date_start': 'datetime'
        }

        self.attribute_map = {
            'ingestion_limit': 'ingestionLimit',
            'tweet_count': 'tweetCount',
            'date_start': 'dateStart'
        }

        self._ingestion_limit = None
        self._tweet_count = None
        self._date_start = None

    @property
    def ingestion_limit(self) -> int:
        """
        Gets the ingestion_limit of this TweetUsage.
        Ingestion limit

        :return: The ingestion_limit of this TweetUsage.
        :rtype: int
        """
        return self._ingestion_limit

    @ingestion_limit.setter
    def ingestion_limit(self, ingestion_limit: int) -> None:
        """
        Sets the ingestion_limit of this TweetUsage.
        Ingestion limit

        :param ingestion_limit: The ingestion_limit of this TweetUsage.
        :type: int
        """
        

        self._ingestion_limit = ingestion_limit

    @property
    def tweet_count(self) -> int:
        """
        Gets the tweet_count of this TweetUsage.
        The number of tweets consumed

        :return: The tweet_count of this TweetUsage.
        :rtype: int
        """
        return self._tweet_count

    @tweet_count.setter
    def tweet_count(self, tweet_count: int) -> None:
        """
        Sets the tweet_count of this TweetUsage.
        The number of tweets consumed

        :param tweet_count: The tweet_count of this TweetUsage.
        :type: int
        """
        

        self._tweet_count = tweet_count

    @property
    def date_start(self) -> datetime:
        """
        Gets the date_start of this TweetUsage.
        The start of the usage period for the currently consumed tweets. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_start of this TweetUsage.
        :rtype: datetime
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: datetime) -> None:
        """
        Sets the date_start of this TweetUsage.
        The start of the usage period for the currently consumed tweets. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_start: The date_start of this TweetUsage.
        :type: datetime
        """
        

        self._date_start = date_start

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

