# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TranscriptionTopicTranscriptWord

class TranscriptionTopicTranscriptAlternative(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TranscriptionTopicTranscriptAlternative - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'confidence': 'float',
            'offset_ms': 'int',
            'duration_ms': 'int',
            'transcript': 'str',
            'words': 'list[TranscriptionTopicTranscriptWord]',
            'decorated_transcript': 'str',
            'decorated_words': 'list[TranscriptionTopicTranscriptWord]'
        }

        self.attribute_map = {
            'confidence': 'confidence',
            'offset_ms': 'offsetMs',
            'duration_ms': 'durationMs',
            'transcript': 'transcript',
            'words': 'words',
            'decorated_transcript': 'decoratedTranscript',
            'decorated_words': 'decoratedWords'
        }

        self._confidence = None
        self._offset_ms = None
        self._duration_ms = None
        self._transcript = None
        self._words = None
        self._decorated_transcript = None
        self._decorated_words = None

    @property
    def confidence(self) -> float:
        """
        Gets the confidence of this TranscriptionTopicTranscriptAlternative.


        :return: The confidence of this TranscriptionTopicTranscriptAlternative.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence: float) -> None:
        """
        Sets the confidence of this TranscriptionTopicTranscriptAlternative.


        :param confidence: The confidence of this TranscriptionTopicTranscriptAlternative.
        :type: float
        """
        

        self._confidence = confidence

    @property
    def offset_ms(self) -> int:
        """
        Gets the offset_ms of this TranscriptionTopicTranscriptAlternative.


        :return: The offset_ms of this TranscriptionTopicTranscriptAlternative.
        :rtype: int
        """
        return self._offset_ms

    @offset_ms.setter
    def offset_ms(self, offset_ms: int) -> None:
        """
        Sets the offset_ms of this TranscriptionTopicTranscriptAlternative.


        :param offset_ms: The offset_ms of this TranscriptionTopicTranscriptAlternative.
        :type: int
        """
        

        self._offset_ms = offset_ms

    @property
    def duration_ms(self) -> int:
        """
        Gets the duration_ms of this TranscriptionTopicTranscriptAlternative.


        :return: The duration_ms of this TranscriptionTopicTranscriptAlternative.
        :rtype: int
        """
        return self._duration_ms

    @duration_ms.setter
    def duration_ms(self, duration_ms: int) -> None:
        """
        Sets the duration_ms of this TranscriptionTopicTranscriptAlternative.


        :param duration_ms: The duration_ms of this TranscriptionTopicTranscriptAlternative.
        :type: int
        """
        

        self._duration_ms = duration_ms

    @property
    def transcript(self) -> str:
        """
        Gets the transcript of this TranscriptionTopicTranscriptAlternative.


        :return: The transcript of this TranscriptionTopicTranscriptAlternative.
        :rtype: str
        """
        return self._transcript

    @transcript.setter
    def transcript(self, transcript: str) -> None:
        """
        Sets the transcript of this TranscriptionTopicTranscriptAlternative.


        :param transcript: The transcript of this TranscriptionTopicTranscriptAlternative.
        :type: str
        """
        

        self._transcript = transcript

    @property
    def words(self) -> List['TranscriptionTopicTranscriptWord']:
        """
        Gets the words of this TranscriptionTopicTranscriptAlternative.


        :return: The words of this TranscriptionTopicTranscriptAlternative.
        :rtype: list[TranscriptionTopicTranscriptWord]
        """
        return self._words

    @words.setter
    def words(self, words: List['TranscriptionTopicTranscriptWord']) -> None:
        """
        Sets the words of this TranscriptionTopicTranscriptAlternative.


        :param words: The words of this TranscriptionTopicTranscriptAlternative.
        :type: list[TranscriptionTopicTranscriptWord]
        """
        

        self._words = words

    @property
    def decorated_transcript(self) -> str:
        """
        Gets the decorated_transcript of this TranscriptionTopicTranscriptAlternative.


        :return: The decorated_transcript of this TranscriptionTopicTranscriptAlternative.
        :rtype: str
        """
        return self._decorated_transcript

    @decorated_transcript.setter
    def decorated_transcript(self, decorated_transcript: str) -> None:
        """
        Sets the decorated_transcript of this TranscriptionTopicTranscriptAlternative.


        :param decorated_transcript: The decorated_transcript of this TranscriptionTopicTranscriptAlternative.
        :type: str
        """
        

        self._decorated_transcript = decorated_transcript

    @property
    def decorated_words(self) -> List['TranscriptionTopicTranscriptWord']:
        """
        Gets the decorated_words of this TranscriptionTopicTranscriptAlternative.


        :return: The decorated_words of this TranscriptionTopicTranscriptAlternative.
        :rtype: list[TranscriptionTopicTranscriptWord]
        """
        return self._decorated_words

    @decorated_words.setter
    def decorated_words(self, decorated_words: List['TranscriptionTopicTranscriptWord']) -> None:
        """
        Sets the decorated_words of this TranscriptionTopicTranscriptAlternative.


        :param decorated_words: The decorated_words of this TranscriptionTopicTranscriptAlternative.
        :type: list[TranscriptionTopicTranscriptWord]
        """
        

        self._decorated_words = decorated_words

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

