# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class TimeOffSettingsRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TimeOffSettingsRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'submission_range_enforced': 'bool',
            'submission_earliest_days_from_now': 'int',
            'submission_latest_days_from_now': 'int'
        }

        self.attribute_map = {
            'submission_range_enforced': 'submissionRangeEnforced',
            'submission_earliest_days_from_now': 'submissionEarliestDaysFromNow',
            'submission_latest_days_from_now': 'submissionLatestDaysFromNow'
        }

        self._submission_range_enforced = None
        self._submission_earliest_days_from_now = None
        self._submission_latest_days_from_now = None

    @property
    def submission_range_enforced(self) -> bool:
        """
        Gets the submission_range_enforced of this TimeOffSettingsRequest.
        Whether to enforce a submission range for agent time off requests

        :return: The submission_range_enforced of this TimeOffSettingsRequest.
        :rtype: bool
        """
        return self._submission_range_enforced

    @submission_range_enforced.setter
    def submission_range_enforced(self, submission_range_enforced: bool) -> None:
        """
        Sets the submission_range_enforced of this TimeOffSettingsRequest.
        Whether to enforce a submission range for agent time off requests

        :param submission_range_enforced: The submission_range_enforced of this TimeOffSettingsRequest.
        :type: bool
        """
        

        self._submission_range_enforced = submission_range_enforced

    @property
    def submission_earliest_days_from_now(self) -> int:
        """
        Gets the submission_earliest_days_from_now of this TimeOffSettingsRequest.
        The earliest number of days from now for which an agent can submit a time off request.  Use negative numbers to indicate days in the past

        :return: The submission_earliest_days_from_now of this TimeOffSettingsRequest.
        :rtype: int
        """
        return self._submission_earliest_days_from_now

    @submission_earliest_days_from_now.setter
    def submission_earliest_days_from_now(self, submission_earliest_days_from_now: int) -> None:
        """
        Sets the submission_earliest_days_from_now of this TimeOffSettingsRequest.
        The earliest number of days from now for which an agent can submit a time off request.  Use negative numbers to indicate days in the past

        :param submission_earliest_days_from_now: The submission_earliest_days_from_now of this TimeOffSettingsRequest.
        :type: int
        """
        

        self._submission_earliest_days_from_now = submission_earliest_days_from_now

    @property
    def submission_latest_days_from_now(self) -> int:
        """
        Gets the submission_latest_days_from_now of this TimeOffSettingsRequest.
        The latest number of days from now for which an agent can submit a time off request

        :return: The submission_latest_days_from_now of this TimeOffSettingsRequest.
        :rtype: int
        """
        return self._submission_latest_days_from_now

    @submission_latest_days_from_now.setter
    def submission_latest_days_from_now(self, submission_latest_days_from_now: int) -> None:
        """
        Sets the submission_latest_days_from_now of this TimeOffSettingsRequest.
        The latest number of days from now for which an agent can submit a time off request

        :param submission_latest_days_from_now: The submission_latest_days_from_now of this TimeOffSettingsRequest.
        :type: int
        """
        

        self._submission_latest_days_from_now = submission_latest_days_from_now

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

