# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class Term(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Term - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'word': 'str',
            'participant_type': 'str'
        }

        self.attribute_map = {
            'word': 'word',
            'participant_type': 'participantType'
        }

        self._word = None
        self._participant_type = None

    @property
    def word(self) -> str:
        """
        Gets the word of this Term.
        Find term in interaction

        :return: The word of this Term.
        :rtype: str
        """
        return self._word

    @word.setter
    def word(self, word: str) -> None:
        """
        Sets the word of this Term.
        Find term in interaction

        :param word: The word of this Term.
        :type: str
        """
        

        self._word = word

    @property
    def participant_type(self) -> str:
        """
        Gets the participant_type of this Term.
        Dictates if term operand must come from the internal, external or both participants

        :return: The participant_type of this Term.
        :rtype: str
        """
        return self._participant_type

    @participant_type.setter
    def participant_type(self, participant_type: str) -> None:
        """
        Sets the participant_type of this Term.
        Dictates if term operand must come from the internal, external or both participants

        :param participant_type: The participant_type of this Term.
        :type: str
        """
        if isinstance(participant_type, int):
            participant_type = str(participant_type)
        allowed_values = ["Internal", "External", "Both"]
        if participant_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for participant_type -> " + participant_type)
            self._participant_type = "outdated_sdk_version"
        else:
            self._participant_type = participant_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

