# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SupportedEntityTypeStatus

class SupportedLanguagesInfoDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SupportedLanguagesInfoDefinition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'language': 'str',
            'intent_classification': 'bool',
            'status': 'str',
            'supported_entity_types': 'list[str]',
            'supported_entity_type_configuration': 'SupportedEntityTypeStatus'
        }

        self.attribute_map = {
            'language': 'language',
            'intent_classification': 'intentClassification',
            'status': 'status',
            'supported_entity_types': 'supportedEntityTypes',
            'supported_entity_type_configuration': 'supportedEntityTypeConfiguration'
        }

        self._language = None
        self._intent_classification = None
        self._status = None
        self._supported_entity_types = None
        self._supported_entity_type_configuration = None

    @property
    def language(self) -> str:
        """
        Gets the language of this SupportedLanguagesInfoDefinition.
        The given supported Language

        :return: The language of this SupportedLanguagesInfoDefinition.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this SupportedLanguagesInfoDefinition.
        The given supported Language

        :param language: The language of this SupportedLanguagesInfoDefinition.
        :type: str
        """
        

        self._language = language

    @property
    def intent_classification(self) -> bool:
        """
        Gets the intent_classification of this SupportedLanguagesInfoDefinition.
        The boolean status of if intent classification is supported in this language

        :return: The intent_classification of this SupportedLanguagesInfoDefinition.
        :rtype: bool
        """
        return self._intent_classification

    @intent_classification.setter
    def intent_classification(self, intent_classification: bool) -> None:
        """
        Sets the intent_classification of this SupportedLanguagesInfoDefinition.
        The boolean status of if intent classification is supported in this language

        :param intent_classification: The intent_classification of this SupportedLanguagesInfoDefinition.
        :type: bool
        """
        

        self._intent_classification = intent_classification

    @property
    def status(self) -> str:
        """
        Gets the status of this SupportedLanguagesInfoDefinition.
        The language release status

        :return: The status of this SupportedLanguagesInfoDefinition.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this SupportedLanguagesInfoDefinition.
        The language release status

        :param status: The status of this SupportedLanguagesInfoDefinition.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["EARLY_PREVIEW", "PREVIEW", "GA"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def supported_entity_types(self) -> List[str]:
        """
        Gets the supported_entity_types of this SupportedLanguagesInfoDefinition.
        The supported entity types for this language

        :return: The supported_entity_types of this SupportedLanguagesInfoDefinition.
        :rtype: list[str]
        """
        return self._supported_entity_types

    @supported_entity_types.setter
    def supported_entity_types(self, supported_entity_types: List[str]) -> None:
        """
        Sets the supported_entity_types of this SupportedLanguagesInfoDefinition.
        The supported entity types for this language

        :param supported_entity_types: The supported_entity_types of this SupportedLanguagesInfoDefinition.
        :type: list[str]
        """
        

        self._supported_entity_types = supported_entity_types

    @property
    def supported_entity_type_configuration(self) -> 'SupportedEntityTypeStatus':
        """
        Gets the supported_entity_type_configuration of this SupportedLanguagesInfoDefinition.
        The configuration for the supported entity types

        :return: The supported_entity_type_configuration of this SupportedLanguagesInfoDefinition.
        :rtype: SupportedEntityTypeStatus
        """
        return self._supported_entity_type_configuration

    @supported_entity_type_configuration.setter
    def supported_entity_type_configuration(self, supported_entity_type_configuration: 'SupportedEntityTypeStatus') -> None:
        """
        Sets the supported_entity_type_configuration of this SupportedLanguagesInfoDefinition.
        The configuration for the supported entity types

        :param supported_entity_type_configuration: The supported_entity_type_configuration of this SupportedLanguagesInfoDefinition.
        :type: SupportedEntityTypeStatus
        """
        

        self._supported_entity_type_configuration = supported_entity_type_configuration

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

