# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class SuggestionScript(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SuggestionScript - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'script': 'AddressableEntityRef',
            'page': 'AddressableEntityRef',
            'data': 'dict(str, str)'
        }

        self.attribute_map = {
            'script': 'script',
            'page': 'page',
            'data': 'data'
        }

        self._script = None
        self._page = None
        self._data = None

    @property
    def script(self) -> 'AddressableEntityRef':
        """
        Gets the script of this SuggestionScript.
        The suggested script.

        :return: The script of this SuggestionScript.
        :rtype: AddressableEntityRef
        """
        return self._script

    @script.setter
    def script(self, script: 'AddressableEntityRef') -> None:
        """
        Sets the script of this SuggestionScript.
        The suggested script.

        :param script: The script of this SuggestionScript.
        :type: AddressableEntityRef
        """
        

        self._script = script

    @property
    def page(self) -> 'AddressableEntityRef':
        """
        Gets the page of this SuggestionScript.
        The page of the script.

        :return: The page of this SuggestionScript.
        :rtype: AddressableEntityRef
        """
        return self._page

    @page.setter
    def page(self, page: 'AddressableEntityRef') -> None:
        """
        Sets the page of this SuggestionScript.
        The page of the script.

        :param page: The page of this SuggestionScript.
        :type: AddressableEntityRef
        """
        

        self._page = page

    @property
    def data(self) -> Dict[str, str]:
        """
        Gets the data of this SuggestionScript.
        The payload for the script.

        :return: The data of this SuggestionScript.
        :rtype: dict(str, str)
        """
        return self._data

    @data.setter
    def data(self, data: Dict[str, str]) -> None:
        """
        Sets the data of this SuggestionScript.
        The payload for the script.

        :param data: The data of this SuggestionScript.
        :type: dict(str, str)
        """
        

        self._data = data

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

