# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import SuggestionKnowledgeAnswer

class SuggestionKnowledgeArticle(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SuggestionKnowledgeArticle - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'title': 'str',
            'snippets': 'list[str]',
            'document': 'AddressableEntityRef',
            'version': 'AddressableEntityRef',
            'knowledge_answer': 'SuggestionKnowledgeAnswer',
            'variations': 'list[AddressableEntityRef]'
        }

        self.attribute_map = {
            'title': 'title',
            'snippets': 'snippets',
            'document': 'document',
            'version': 'version',
            'knowledge_answer': 'knowledgeAnswer',
            'variations': 'variations'
        }

        self._title = None
        self._snippets = None
        self._document = None
        self._version = None
        self._knowledge_answer = None
        self._variations = None

    @property
    def title(self) -> str:
        """
        Gets the title of this SuggestionKnowledgeArticle.
        The article title.

        :return: The title of this SuggestionKnowledgeArticle.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this SuggestionKnowledgeArticle.
        The article title.

        :param title: The title of this SuggestionKnowledgeArticle.
        :type: str
        """
        

        self._title = title

    @property
    def snippets(self) -> List[str]:
        """
        Gets the snippets of this SuggestionKnowledgeArticle.
        Snippets of text from the article matching the query.

        :return: The snippets of this SuggestionKnowledgeArticle.
        :rtype: list[str]
        """
        return self._snippets

    @snippets.setter
    def snippets(self, snippets: List[str]) -> None:
        """
        Sets the snippets of this SuggestionKnowledgeArticle.
        Snippets of text from the article matching the query.

        :param snippets: The snippets of this SuggestionKnowledgeArticle.
        :type: list[str]
        """
        

        self._snippets = snippets

    @property
    def document(self) -> 'AddressableEntityRef':
        """
        Gets the document of this SuggestionKnowledgeArticle.
        The article.

        :return: The document of this SuggestionKnowledgeArticle.
        :rtype: AddressableEntityRef
        """
        return self._document

    @document.setter
    def document(self, document: 'AddressableEntityRef') -> None:
        """
        Sets the document of this SuggestionKnowledgeArticle.
        The article.

        :param document: The document of this SuggestionKnowledgeArticle.
        :type: AddressableEntityRef
        """
        

        self._document = document

    @property
    def version(self) -> 'AddressableEntityRef':
        """
        Gets the version of this SuggestionKnowledgeArticle.
        The version of the article.

        :return: The version of this SuggestionKnowledgeArticle.
        :rtype: AddressableEntityRef
        """
        return self._version

    @version.setter
    def version(self, version: 'AddressableEntityRef') -> None:
        """
        Sets the version of this SuggestionKnowledgeArticle.
        The version of the article.

        :param version: The version of this SuggestionKnowledgeArticle.
        :type: AddressableEntityRef
        """
        

        self._version = version

    @property
    def knowledge_answer(self) -> 'SuggestionKnowledgeAnswer':
        """
        Gets the knowledge_answer of this SuggestionKnowledgeArticle.
        The most relevant answer within the suggested article.

        :return: The knowledge_answer of this SuggestionKnowledgeArticle.
        :rtype: SuggestionKnowledgeAnswer
        """
        return self._knowledge_answer

    @knowledge_answer.setter
    def knowledge_answer(self, knowledge_answer: 'SuggestionKnowledgeAnswer') -> None:
        """
        Sets the knowledge_answer of this SuggestionKnowledgeArticle.
        The most relevant answer within the suggested article.

        :param knowledge_answer: The knowledge_answer of this SuggestionKnowledgeArticle.
        :type: SuggestionKnowledgeAnswer
        """
        

        self._knowledge_answer = knowledge_answer

    @property
    def variations(self) -> List['AddressableEntityRef']:
        """
        Gets the variations of this SuggestionKnowledgeArticle.
        The variations of the article.

        :return: The variations of this SuggestionKnowledgeArticle.
        :rtype: list[AddressableEntityRef]
        """
        return self._variations

    @variations.setter
    def variations(self, variations: List['AddressableEntityRef']) -> None:
        """
        Sets the variations of this SuggestionKnowledgeArticle.
        The variations of the article.

        :param variations: The variations of this SuggestionKnowledgeArticle.
        :type: list[AddressableEntityRef]
        """
        

        self._variations = variations

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

