# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import Entity
    from . import UserReference

class SuggestionContext(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SuggestionContext - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'queue': 'AddressableEntityRef',
            'media_type': 'str',
            'user': 'UserReference',
            'external_contact': 'AddressableEntityRef',
            'utterance': 'Entity',
            'message': 'AddressableEntityRef',
            'query_statement': 'str'
        }

        self.attribute_map = {
            'queue': 'queue',
            'media_type': 'mediaType',
            'user': 'user',
            'external_contact': 'externalContact',
            'utterance': 'utterance',
            'message': 'message',
            'query_statement': 'queryStatement'
        }

        self._queue = None
        self._media_type = None
        self._user = None
        self._external_contact = None
        self._utterance = None
        self._message = None
        self._query_statement = None

    @property
    def queue(self) -> 'AddressableEntityRef':
        """
        Gets the queue of this SuggestionContext.
        The queue used to assign the interaction to the user, if any.

        :return: The queue of this SuggestionContext.
        :rtype: AddressableEntityRef
        """
        return self._queue

    @queue.setter
    def queue(self, queue: 'AddressableEntityRef') -> None:
        """
        Sets the queue of this SuggestionContext.
        The queue used to assign the interaction to the user, if any.

        :param queue: The queue of this SuggestionContext.
        :type: AddressableEntityRef
        """
        

        self._queue = queue

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this SuggestionContext.
        The media type of the conversation in which the suggestion event was raised.

        :return: The media_type of this SuggestionContext.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this SuggestionContext.
        The media type of the conversation in which the suggestion event was raised.

        :param media_type: The media_type of this SuggestionContext.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["Message", "Voice", "Unknown"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def user(self) -> 'UserReference':
        """
        Gets the user of this SuggestionContext.
        The agent participant who received the raised suggestion, if any.

        :return: The user of this SuggestionContext.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'UserReference') -> None:
        """
        Sets the user of this SuggestionContext.
        The agent participant who received the raised suggestion, if any.

        :param user: The user of this SuggestionContext.
        :type: UserReference
        """
        

        self._user = user

    @property
    def external_contact(self) -> 'AddressableEntityRef':
        """
        Gets the external_contact of this SuggestionContext.
        The external contact of the end-user participant, if any.

        :return: The external_contact of this SuggestionContext.
        :rtype: AddressableEntityRef
        """
        return self._external_contact

    @external_contact.setter
    def external_contact(self, external_contact: 'AddressableEntityRef') -> None:
        """
        Sets the external_contact of this SuggestionContext.
        The external contact of the end-user participant, if any.

        :param external_contact: The external_contact of this SuggestionContext.
        :type: AddressableEntityRef
        """
        

        self._external_contact = external_contact

    @property
    def utterance(self) -> 'Entity':
        """
        Gets the utterance of this SuggestionContext.
        The utterance in the voice conversation, after which the suggestion was raised, if any.

        :return: The utterance of this SuggestionContext.
        :rtype: Entity
        """
        return self._utterance

    @utterance.setter
    def utterance(self, utterance: 'Entity') -> None:
        """
        Sets the utterance of this SuggestionContext.
        The utterance in the voice conversation, after which the suggestion was raised, if any.

        :param utterance: The utterance of this SuggestionContext.
        :type: Entity
        """
        

        self._utterance = utterance

    @property
    def message(self) -> 'AddressableEntityRef':
        """
        Gets the message of this SuggestionContext.
        The message in the digital conversation, after which the suggestion was raised, if any.

        :return: The message of this SuggestionContext.
        :rtype: AddressableEntityRef
        """
        return self._message

    @message.setter
    def message(self, message: 'AddressableEntityRef') -> None:
        """
        Sets the message of this SuggestionContext.
        The message in the digital conversation, after which the suggestion was raised, if any.

        :param message: The message of this SuggestionContext.
        :type: AddressableEntityRef
        """
        

        self._message = message

    @property
    def query_statement(self) -> str:
        """
        Gets the query_statement of this SuggestionContext.
        The query statement used when generating the suggestion, if any.

        :return: The query_statement of this SuggestionContext.
        :rtype: str
        """
        return self._query_statement

    @query_statement.setter
    def query_statement(self, query_statement: str) -> None:
        """
        Sets the query_statement of this SuggestionContext.
        The query statement used when generating the suggestion, if any.

        :param query_statement: The query_statement of this SuggestionContext.
        :type: str
        """
        

        self._query_statement = query_statement

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

