# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class SpeechTextAnalyticsConversationSummary(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SpeechTextAnalyticsConversationSummary - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'summary_type': 'str',
            'media_type': 'str',
            'language': 'str',
            'agent_id': 'str',
            'summary': 'str',
            'generated': 'bool',
            'date_created': 'datetime'
        }

        self.attribute_map = {
            'summary_type': 'summaryType',
            'media_type': 'mediaType',
            'language': 'language',
            'agent_id': 'agentId',
            'summary': 'summary',
            'generated': 'generated',
            'date_created': 'dateCreated'
        }

        self._summary_type = None
        self._media_type = None
        self._language = None
        self._agent_id = None
        self._summary = None
        self._generated = None
        self._date_created = None

    @property
    def summary_type(self) -> str:
        """
        Gets the summary_type of this SpeechTextAnalyticsConversationSummary.
        The type of summary

        :return: The summary_type of this SpeechTextAnalyticsConversationSummary.
        :rtype: str
        """
        return self._summary_type

    @summary_type.setter
    def summary_type(self, summary_type: str) -> None:
        """
        Sets the summary_type of this SpeechTextAnalyticsConversationSummary.
        The type of summary

        :param summary_type: The summary_type of this SpeechTextAnalyticsConversationSummary.
        :type: str
        """
        if isinstance(summary_type, int):
            summary_type = str(summary_type)
        allowed_values = ["Conversation", "Agent"]
        if summary_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for summary_type -> " + summary_type)
            self._summary_type = "outdated_sdk_version"
        else:
            self._summary_type = summary_type

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this SpeechTextAnalyticsConversationSummary.
        The media type of the associated interaction

        :return: The media_type of this SpeechTextAnalyticsConversationSummary.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this SpeechTextAnalyticsConversationSummary.
        The media type of the associated interaction

        :param media_type: The media_type of this SpeechTextAnalyticsConversationSummary.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["Unknown", "Message", "Call", "Email"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def language(self) -> str:
        """
        Gets the language of this SpeechTextAnalyticsConversationSummary.
        Language of the summary

        :return: The language of this SpeechTextAnalyticsConversationSummary.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this SpeechTextAnalyticsConversationSummary.
        Language of the summary

        :param language: The language of this SpeechTextAnalyticsConversationSummary.
        :type: str
        """
        

        self._language = language

    @property
    def agent_id(self) -> str:
        """
        Gets the agent_id of this SpeechTextAnalyticsConversationSummary.
        The id of the agent associated with the summary

        :return: The agent_id of this SpeechTextAnalyticsConversationSummary.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id: str) -> None:
        """
        Sets the agent_id of this SpeechTextAnalyticsConversationSummary.
        The id of the agent associated with the summary

        :param agent_id: The agent_id of this SpeechTextAnalyticsConversationSummary.
        :type: str
        """
        

        self._agent_id = agent_id

    @property
    def summary(self) -> str:
        """
        Gets the summary of this SpeechTextAnalyticsConversationSummary.
        A summarization of the conversation transcription

        :return: The summary of this SpeechTextAnalyticsConversationSummary.
        :rtype: str
        """
        return self._summary

    @summary.setter
    def summary(self, summary: str) -> None:
        """
        Sets the summary of this SpeechTextAnalyticsConversationSummary.
        A summarization of the conversation transcription

        :param summary: The summary of this SpeechTextAnalyticsConversationSummary.
        :type: str
        """
        

        self._summary = summary

    @property
    def generated(self) -> bool:
        """
        Gets the generated of this SpeechTextAnalyticsConversationSummary.
        Indicates whether or not the summary was generated by AI

        :return: The generated of this SpeechTextAnalyticsConversationSummary.
        :rtype: bool
        """
        return self._generated

    @generated.setter
    def generated(self, generated: bool) -> None:
        """
        Sets the generated of this SpeechTextAnalyticsConversationSummary.
        Indicates whether or not the summary was generated by AI

        :param generated: The generated of this SpeechTextAnalyticsConversationSummary.
        :type: bool
        """
        

        self._generated = generated

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this SpeechTextAnalyticsConversationSummary.
        Timestamp of when the summary was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this SpeechTextAnalyticsConversationSummary.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this SpeechTextAnalyticsConversationSummary.
        Timestamp of when the summary was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this SpeechTextAnalyticsConversationSummary.
        :type: datetime
        """
        

        self._date_created = date_created

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

