# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import KnowledgeIntegrationReference
    from . import SourceLastSync

class SourceBaseResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SourceBaseResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'type': 'str',
            'integration': 'KnowledgeIntegrationReference',
            'schedule_period': 'int',
            'last_sync': 'SourceLastSync',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'type': 'type',
            'integration': 'integration',
            'schedule_period': 'schedulePeriod',
            'last_sync': 'lastSync',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._type = None
        self._integration = None
        self._schedule_period = None
        self._last_sync = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this SourceBaseResponse.
        The globally unique identifier for the object.

        :return: The id of this SourceBaseResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this SourceBaseResponse.
        The globally unique identifier for the object.

        :param id: The id of this SourceBaseResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this SourceBaseResponse.
        Name of the source.

        :return: The name of this SourceBaseResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this SourceBaseResponse.
        Name of the source.

        :param name: The name of this SourceBaseResponse.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this SourceBaseResponse.
        Source creation date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this SourceBaseResponse.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this SourceBaseResponse.
        Source creation date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this SourceBaseResponse.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this SourceBaseResponse.
        Source last modification date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this SourceBaseResponse.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this SourceBaseResponse.
        Source last modification date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this SourceBaseResponse.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def type(self) -> str:
        """
        Gets the type of this SourceBaseResponse.
        The source type.

        :return: The type of this SourceBaseResponse.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this SourceBaseResponse.
        The source type.

        :param type: The type of this SourceBaseResponse.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Salesforce", "ServiceNow"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def integration(self) -> 'KnowledgeIntegrationReference':
        """
        Gets the integration of this SourceBaseResponse.
        The reference to the integration associated with the source.

        :return: The integration of this SourceBaseResponse.
        :rtype: KnowledgeIntegrationReference
        """
        return self._integration

    @integration.setter
    def integration(self, integration: 'KnowledgeIntegrationReference') -> None:
        """
        Sets the integration of this SourceBaseResponse.
        The reference to the integration associated with the source.

        :param integration: The integration of this SourceBaseResponse.
        :type: KnowledgeIntegrationReference
        """
        

        self._integration = integration

    @property
    def schedule_period(self) -> int:
        """
        Gets the schedule_period of this SourceBaseResponse.
        The schedule period of the source in hours.

        :return: The schedule_period of this SourceBaseResponse.
        :rtype: int
        """
        return self._schedule_period

    @schedule_period.setter
    def schedule_period(self, schedule_period: int) -> None:
        """
        Sets the schedule_period of this SourceBaseResponse.
        The schedule period of the source in hours.

        :param schedule_period: The schedule_period of this SourceBaseResponse.
        :type: int
        """
        

        self._schedule_period = schedule_period

    @property
    def last_sync(self) -> 'SourceLastSync':
        """
        Gets the last_sync of this SourceBaseResponse.
        Additional information about the last synchronization of the source.

        :return: The last_sync of this SourceBaseResponse.
        :rtype: SourceLastSync
        """
        return self._last_sync

    @last_sync.setter
    def last_sync(self, last_sync: 'SourceLastSync') -> None:
        """
        Sets the last_sync of this SourceBaseResponse.
        Additional information about the last synchronization of the source.

        :param last_sync: The last_sync of this SourceBaseResponse.
        :type: SourceLastSync
        """
        

        self._last_sync = last_sync

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this SourceBaseResponse.
        The URI for this object

        :return: The self_uri of this SourceBaseResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this SourceBaseResponse.
        The URI for this object

        :param self_uri: The self_uri of this SourceBaseResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

