# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SkillGroupCondition
    from . import WritableDivision

class SkillGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SkillGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'division': 'WritableDivision',
            'description': 'str',
            'member_count': 'int',
            'date_modified': 'datetime',
            'date_created': 'datetime',
            'status': 'str',
            'skill_conditions': 'list[SkillGroupCondition]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'division': 'division',
            'description': 'description',
            'member_count': 'memberCount',
            'date_modified': 'dateModified',
            'date_created': 'dateCreated',
            'status': 'status',
            'skill_conditions': 'skillConditions',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._division = None
        self._description = None
        self._member_count = None
        self._date_modified = None
        self._date_created = None
        self._status = None
        self._skill_conditions = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this SkillGroup.
        The globally unique identifier for the object.

        :return: The id of this SkillGroup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this SkillGroup.
        The globally unique identifier for the object.

        :param id: The id of this SkillGroup.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this SkillGroup.
        The group name.

        :return: The name of this SkillGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this SkillGroup.
        The group name.

        :param name: The name of this SkillGroup.
        :type: str
        """
        

        self._name = name

    @property
    def division(self) -> 'WritableDivision':
        """
        Gets the division of this SkillGroup.
        The division to which this entity belongs.

        :return: The division of this SkillGroup.
        :rtype: WritableDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'WritableDivision') -> None:
        """
        Sets the division of this SkillGroup.
        The division to which this entity belongs.

        :param division: The division of this SkillGroup.
        :type: WritableDivision
        """
        

        self._division = division

    @property
    def description(self) -> str:
        """
        Gets the description of this SkillGroup.
        Group description

        :return: The description of this SkillGroup.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this SkillGroup.
        Group description

        :param description: The description of this SkillGroup.
        :type: str
        """
        

        self._description = description

    @property
    def member_count(self) -> int:
        """
        Gets the member_count of this SkillGroup.
        Estimated number of members in this group. It can take some time for the count to be updated after expressions are changed.

        :return: The member_count of this SkillGroup.
        :rtype: int
        """
        return self._member_count

    @member_count.setter
    def member_count(self, member_count: int) -> None:
        """
        Sets the member_count of this SkillGroup.
        Estimated number of members in this group. It can take some time for the count to be updated after expressions are changed.

        :param member_count: The member_count of this SkillGroup.
        :type: int
        """
        

        self._member_count = member_count

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this SkillGroup.
        Last modified date/time of the skill group. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this SkillGroup.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this SkillGroup.
        Last modified date/time of the skill group. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this SkillGroup.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this SkillGroup.
        Created date/time of the skill group. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this SkillGroup.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this SkillGroup.
        Created date/time of the skill group. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this SkillGroup.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def status(self) -> str:
        """
        Gets the status of this SkillGroup.
        Group's filling status

        :return: The status of this SkillGroup.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this SkillGroup.
        Group's filling status

        :param status: The status of this SkillGroup.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["InProgress", "Complete"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def skill_conditions(self) -> List['SkillGroupCondition']:
        """
        Gets the skill_conditions of this SkillGroup.
        Conditions for this group

        :return: The skill_conditions of this SkillGroup.
        :rtype: list[SkillGroupCondition]
        """
        return self._skill_conditions

    @skill_conditions.setter
    def skill_conditions(self, skill_conditions: List['SkillGroupCondition']) -> None:
        """
        Sets the skill_conditions of this SkillGroup.
        Conditions for this group

        :param skill_conditions: The skill_conditions of this SkillGroup.
        :type: list[SkillGroupCondition]
        """
        

        self._skill_conditions = skill_conditions

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this SkillGroup.
        The URI for this object

        :return: The self_uri of this SkillGroup.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this SkillGroup.
        The URI for this object

        :param self_uri: The self_uri of this SkillGroup.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

