# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ShiftTradeActivityPreviewResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ShiftTradeActivityPreviewResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'start_date': 'datetime',
            'length_minutes': 'int',
            'activity_code_id': 'str',
            'counts_as_paid_time': 'bool',
            'payable_minutes': 'int'
        }

        self.attribute_map = {
            'start_date': 'startDate',
            'length_minutes': 'lengthMinutes',
            'activity_code_id': 'activityCodeId',
            'counts_as_paid_time': 'countsAsPaidTime',
            'payable_minutes': 'payableMinutes'
        }

        self._start_date = None
        self._length_minutes = None
        self._activity_code_id = None
        self._counts_as_paid_time = None
        self._payable_minutes = None

    @property
    def start_date(self) -> datetime:
        """
        Gets the start_date of this ShiftTradeActivityPreviewResponse.
        The start date and time of this activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_date of this ShiftTradeActivityPreviewResponse.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date: datetime) -> None:
        """
        Sets the start_date of this ShiftTradeActivityPreviewResponse.
        The start date and time of this activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_date: The start_date of this ShiftTradeActivityPreviewResponse.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def length_minutes(self) -> int:
        """
        Gets the length_minutes of this ShiftTradeActivityPreviewResponse.
        The length in minutes of this activity

        :return: The length_minutes of this ShiftTradeActivityPreviewResponse.
        :rtype: int
        """
        return self._length_minutes

    @length_minutes.setter
    def length_minutes(self, length_minutes: int) -> None:
        """
        Sets the length_minutes of this ShiftTradeActivityPreviewResponse.
        The length in minutes of this activity

        :param length_minutes: The length_minutes of this ShiftTradeActivityPreviewResponse.
        :type: int
        """
        

        self._length_minutes = length_minutes

    @property
    def activity_code_id(self) -> str:
        """
        Gets the activity_code_id of this ShiftTradeActivityPreviewResponse.
        The ID of the activity code for this activity

        :return: The activity_code_id of this ShiftTradeActivityPreviewResponse.
        :rtype: str
        """
        return self._activity_code_id

    @activity_code_id.setter
    def activity_code_id(self, activity_code_id: str) -> None:
        """
        Sets the activity_code_id of this ShiftTradeActivityPreviewResponse.
        The ID of the activity code for this activity

        :param activity_code_id: The activity_code_id of this ShiftTradeActivityPreviewResponse.
        :type: str
        """
        

        self._activity_code_id = activity_code_id

    @property
    def counts_as_paid_time(self) -> bool:
        """
        Gets the counts_as_paid_time of this ShiftTradeActivityPreviewResponse.
        Whether this activity counts as paid time

        :return: The counts_as_paid_time of this ShiftTradeActivityPreviewResponse.
        :rtype: bool
        """
        return self._counts_as_paid_time

    @counts_as_paid_time.setter
    def counts_as_paid_time(self, counts_as_paid_time: bool) -> None:
        """
        Sets the counts_as_paid_time of this ShiftTradeActivityPreviewResponse.
        Whether this activity counts as paid time

        :param counts_as_paid_time: The counts_as_paid_time of this ShiftTradeActivityPreviewResponse.
        :type: bool
        """
        

        self._counts_as_paid_time = counts_as_paid_time

    @property
    def payable_minutes(self) -> int:
        """
        Gets the payable_minutes of this ShiftTradeActivityPreviewResponse.
        Payable minutes for this activity

        :return: The payable_minutes of this ShiftTradeActivityPreviewResponse.
        :rtype: int
        """
        return self._payable_minutes

    @payable_minutes.setter
    def payable_minutes(self, payable_minutes: int) -> None:
        """
        Sets the payable_minutes of this ShiftTradeActivityPreviewResponse.
        Payable minutes for this activity

        :param payable_minutes: The payable_minutes of this ShiftTradeActivityPreviewResponse.
        :type: int
        """
        

        self._payable_minutes = payable_minutes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

