# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ServiceNowSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ServiceNowSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'knowledge_base_ids': 'list[str]',
            'language': 'str',
            'categories': 'list[str]',
            'base_url': 'str'
        }

        self.attribute_map = {
            'knowledge_base_ids': 'knowledgeBaseIds',
            'language': 'language',
            'categories': 'categories',
            'base_url': 'baseUrl'
        }

        self._knowledge_base_ids = None
        self._language = None
        self._categories = None
        self._base_url = None

    @property
    def knowledge_base_ids(self) -> List[str]:
        """
        Gets the knowledge_base_ids of this ServiceNowSettings.
        Filter source by knowledge base ids.

        :return: The knowledge_base_ids of this ServiceNowSettings.
        :rtype: list[str]
        """
        return self._knowledge_base_ids

    @knowledge_base_ids.setter
    def knowledge_base_ids(self, knowledge_base_ids: List[str]) -> None:
        """
        Sets the knowledge_base_ids of this ServiceNowSettings.
        Filter source by knowledge base ids.

        :param knowledge_base_ids: The knowledge_base_ids of this ServiceNowSettings.
        :type: list[str]
        """
        

        self._knowledge_base_ids = knowledge_base_ids

    @property
    def language(self) -> str:
        """
        Gets the language of this ServiceNowSettings.
        Filter source by language.

        :return: The language of this ServiceNowSettings.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this ServiceNowSettings.
        Filter source by language.

        :param language: The language of this ServiceNowSettings.
        :type: str
        """
        

        self._language = language

    @property
    def categories(self) -> List[str]:
        """
        Gets the categories of this ServiceNowSettings.
        Filter source by categories.

        :return: The categories of this ServiceNowSettings.
        :rtype: list[str]
        """
        return self._categories

    @categories.setter
    def categories(self, categories: List[str]) -> None:
        """
        Sets the categories of this ServiceNowSettings.
        Filter source by categories.

        :param categories: The categories of this ServiceNowSettings.
        :type: list[str]
        """
        

        self._categories = categories

    @property
    def base_url(self) -> str:
        """
        Gets the base_url of this ServiceNowSettings.
        The base URL to resources.

        :return: The base_url of this ServiceNowSettings.
        :rtype: str
        """
        return self._base_url

    @base_url.setter
    def base_url(self, base_url: str) -> None:
        """
        Sets the base_url of this ServiceNowSettings.
        The base URL to resources.

        :param base_url: The base_url of this ServiceNowSettings.
        :type: str
        """
        

        self._base_url = base_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

