# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class SelectedCustomCalculationColumns(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SelectedCustomCalculationColumns - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'custom_calculation': 'AddressableEntityRef',
            'restricted': 'bool',
            'soft_deleted': 'bool'
        }

        self.attribute_map = {
            'custom_calculation': 'customCalculation',
            'restricted': 'restricted',
            'soft_deleted': 'softDeleted'
        }

        self._custom_calculation = None
        self._restricted = None
        self._soft_deleted = None

    @property
    def custom_calculation(self) -> 'AddressableEntityRef':
        """
        Gets the custom_calculation of this SelectedCustomCalculationColumns.
        Custom calculation added as a column

        :return: The custom_calculation of this SelectedCustomCalculationColumns.
        :rtype: AddressableEntityRef
        """
        return self._custom_calculation

    @custom_calculation.setter
    def custom_calculation(self, custom_calculation: 'AddressableEntityRef') -> None:
        """
        Sets the custom_calculation of this SelectedCustomCalculationColumns.
        Custom calculation added as a column

        :param custom_calculation: The custom_calculation of this SelectedCustomCalculationColumns.
        :type: AddressableEntityRef
        """
        

        self._custom_calculation = custom_calculation

    @property
    def restricted(self) -> bool:
        """
        Gets the restricted of this SelectedCustomCalculationColumns.
        Indicates if selected custom calculation column is deleted or access revoked for the user

        :return: The restricted of this SelectedCustomCalculationColumns.
        :rtype: bool
        """
        return self._restricted

    @restricted.setter
    def restricted(self, restricted: bool) -> None:
        """
        Sets the restricted of this SelectedCustomCalculationColumns.
        Indicates if selected custom calculation column is deleted or access revoked for the user

        :param restricted: The restricted of this SelectedCustomCalculationColumns.
        :type: bool
        """
        

        self._restricted = restricted

    @property
    def soft_deleted(self) -> bool:
        """
        Gets the soft_deleted of this SelectedCustomCalculationColumns.
        Is selected custom calculation column soft deleted

        :return: The soft_deleted of this SelectedCustomCalculationColumns.
        :rtype: bool
        """
        return self._soft_deleted

    @soft_deleted.setter
    def soft_deleted(self, soft_deleted: bool) -> None:
        """
        Sets the soft_deleted of this SelectedCustomCalculationColumns.
        Is selected custom calculation column soft deleted

        :param soft_deleted: The soft_deleted of this SelectedCustomCalculationColumns.
        :type: bool
        """
        

        self._soft_deleted = soft_deleted

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

