# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class RoutingActivityMetricValue(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RoutingActivityMetricValue - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'metric': 'str',
            'qualifier': 'str',
            'secondary_qualifier': 'str',
            'entity_ids': 'list[str]',
            'count': 'int'
        }

        self.attribute_map = {
            'metric': 'metric',
            'qualifier': 'qualifier',
            'secondary_qualifier': 'secondaryQualifier',
            'entity_ids': 'entityIds',
            'count': 'count'
        }

        self._metric = None
        self._qualifier = None
        self._secondary_qualifier = None
        self._entity_ids = None
        self._count = None

    @property
    def metric(self) -> str:
        """
        Gets the metric of this RoutingActivityMetricValue.
        Metric

        :return: The metric of this RoutingActivityMetricValue.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric: str) -> None:
        """
        Sets the metric of this RoutingActivityMetricValue.
        Metric

        :param metric: The metric of this RoutingActivityMetricValue.
        :type: str
        """
        if isinstance(metric, int):
            metric = str(metric)
        allowed_values = ["oActiveUsers", "oMemberUsers", "oOffQueueUsers", "oOnQueueUsers", "oUserPresences", "oUserRoutingStatuses"]
        if metric.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric -> " + metric)
            self._metric = "outdated_sdk_version"
        else:
            self._metric = metric

    @property
    def qualifier(self) -> str:
        """
        Gets the qualifier of this RoutingActivityMetricValue.
        Metric qualifier

        :return: The qualifier of this RoutingActivityMetricValue.
        :rtype: str
        """
        return self._qualifier

    @qualifier.setter
    def qualifier(self, qualifier: str) -> None:
        """
        Sets the qualifier of this RoutingActivityMetricValue.
        Metric qualifier

        :param qualifier: The qualifier of this RoutingActivityMetricValue.
        :type: str
        """
        

        self._qualifier = qualifier

    @property
    def secondary_qualifier(self) -> str:
        """
        Gets the secondary_qualifier of this RoutingActivityMetricValue.
        Secondary metric qualifier

        :return: The secondary_qualifier of this RoutingActivityMetricValue.
        :rtype: str
        """
        return self._secondary_qualifier

    @secondary_qualifier.setter
    def secondary_qualifier(self, secondary_qualifier: str) -> None:
        """
        Sets the secondary_qualifier of this RoutingActivityMetricValue.
        Secondary metric qualifier

        :param secondary_qualifier: The secondary_qualifier of this RoutingActivityMetricValue.
        :type: str
        """
        

        self._secondary_qualifier = secondary_qualifier

    @property
    def entity_ids(self) -> List[str]:
        """
        Gets the entity_ids of this RoutingActivityMetricValue.
        Entity ids for matching entities if details were requested

        :return: The entity_ids of this RoutingActivityMetricValue.
        :rtype: list[str]
        """
        return self._entity_ids

    @entity_ids.setter
    def entity_ids(self, entity_ids: List[str]) -> None:
        """
        Sets the entity_ids of this RoutingActivityMetricValue.
        Entity ids for matching entities if details were requested

        :param entity_ids: The entity_ids of this RoutingActivityMetricValue.
        :type: list[str]
        """
        

        self._entity_ids = entity_ids

    @property
    def count(self) -> int:
        """
        Gets the count of this RoutingActivityMetricValue.
        Metric count

        :return: The count of this RoutingActivityMetricValue.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count: int) -> None:
        """
        Sets the count of this RoutingActivityMetricValue.
        Metric count

        :param count: The count of this RoutingActivityMetricValue.
        :type: int
        """
        

        self._count = count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

