# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SourcePlanningGroupRequest

class RoutePathRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RoutePathRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'queue_id': 'str',
            'media_type': 'str',
            'language_id': 'str',
            'skill_ids': 'list[str]',
            'source_planning_group': 'SourcePlanningGroupRequest'
        }

        self.attribute_map = {
            'queue_id': 'queueId',
            'media_type': 'mediaType',
            'language_id': 'languageId',
            'skill_ids': 'skillIds',
            'source_planning_group': 'sourcePlanningGroup'
        }

        self._queue_id = None
        self._media_type = None
        self._language_id = None
        self._skill_ids = None
        self._source_planning_group = None

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this RoutePathRequest.
        The ID of the queue to associate with the route path

        :return: The queue_id of this RoutePathRequest.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this RoutePathRequest.
        The ID of the queue to associate with the route path

        :param queue_id: The queue_id of this RoutePathRequest.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this RoutePathRequest.
        The media type of the given queue to associate with the route path

        :return: The media_type of this RoutePathRequest.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this RoutePathRequest.
        The media type of the given queue to associate with the route path

        :param media_type: The media_type of this RoutePathRequest.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["Voice", "Chat", "Email", "Callback", "Message", "Workitem"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def language_id(self) -> str:
        """
        Gets the language_id of this RoutePathRequest.
        The ID of the language to associate with the route path

        :return: The language_id of this RoutePathRequest.
        :rtype: str
        """
        return self._language_id

    @language_id.setter
    def language_id(self, language_id: str) -> None:
        """
        Sets the language_id of this RoutePathRequest.
        The ID of the language to associate with the route path

        :param language_id: The language_id of this RoutePathRequest.
        :type: str
        """
        

        self._language_id = language_id

    @property
    def skill_ids(self) -> List[str]:
        """
        Gets the skill_ids of this RoutePathRequest.
        The set of skill IDs to associate with the route path

        :return: The skill_ids of this RoutePathRequest.
        :rtype: list[str]
        """
        return self._skill_ids

    @skill_ids.setter
    def skill_ids(self, skill_ids: List[str]) -> None:
        """
        Sets the skill_ids of this RoutePathRequest.
        The set of skill IDs to associate with the route path

        :param skill_ids: The skill_ids of this RoutePathRequest.
        :type: list[str]
        """
        

        self._skill_ids = skill_ids

    @property
    def source_planning_group(self) -> 'SourcePlanningGroupRequest':
        """
        Gets the source_planning_group of this RoutePathRequest.
        The planning group from which to take route paths. This property is only needed if a route path already exists in another planning group.Note that taking a route path from another planning group will modify the other planning group

        :return: The source_planning_group of this RoutePathRequest.
        :rtype: SourcePlanningGroupRequest
        """
        return self._source_planning_group

    @source_planning_group.setter
    def source_planning_group(self, source_planning_group: 'SourcePlanningGroupRequest') -> None:
        """
        Sets the source_planning_group of this RoutePathRequest.
        The planning group from which to take route paths. This property is only needed if a route path already exists in another planning group.Note that taking a route path from another planning group will modify the other planning group

        :param source_planning_group: The source_planning_group of this RoutePathRequest.
        :type: SourcePlanningGroupRequest
        """
        

        self._source_planning_group = source_planning_group

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

