# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class RoleSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RoleSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'backfill_enabled': 'bool',
            'authorization_grant_division_aware': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'backfill_enabled': 'backfillEnabled',
            'authorization_grant_division_aware': 'authorizationGrantDivisionAware',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._backfill_enabled = None
        self._authorization_grant_division_aware = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this RoleSettings.
        The globally unique identifier for the object.

        :return: The id of this RoleSettings.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this RoleSettings.
        The globally unique identifier for the object.

        :param id: The id of this RoleSettings.
        :type: str
        """
        

        self._id = id

    @property
    def backfill_enabled(self) -> bool:
        """
        Gets the backfill_enabled of this RoleSettings.
        Boolean showing if organization is opted in or not to role backfills

        :return: The backfill_enabled of this RoleSettings.
        :rtype: bool
        """
        return self._backfill_enabled

    @backfill_enabled.setter
    def backfill_enabled(self, backfill_enabled: bool) -> None:
        """
        Sets the backfill_enabled of this RoleSettings.
        Boolean showing if organization is opted in or not to role backfills

        :param backfill_enabled: The backfill_enabled of this RoleSettings.
        :type: bool
        """
        

        self._backfill_enabled = backfill_enabled

    @property
    def authorization_grant_division_aware(self) -> bool:
        """
        Gets the authorization_grant_division_aware of this RoleSettings.
        Boolean enabling enforcement of division aware for authorization grant add and delete

        :return: The authorization_grant_division_aware of this RoleSettings.
        :rtype: bool
        """
        return self._authorization_grant_division_aware

    @authorization_grant_division_aware.setter
    def authorization_grant_division_aware(self, authorization_grant_division_aware: bool) -> None:
        """
        Sets the authorization_grant_division_aware of this RoleSettings.
        Boolean enabling enforcement of division aware for authorization grant add and delete

        :param authorization_grant_division_aware: The authorization_grant_division_aware of this RoleSettings.
        :type: bool
        """
        

        self._authorization_grant_division_aware = authorization_grant_division_aware

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this RoleSettings.
        The URI for this object

        :return: The self_uri of this RoleSettings.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this RoleSettings.
        The URI for this object

        :param self_uri: The self_uri of this RoleSettings.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

