# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ResponsePage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ResponsePage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'url': 'str',
            'title': 'str',
            'domain': 'str',
            'fragment': 'str',
            'hostname': 'str',
            'keywords': 'str',
            'lang': 'str',
            'pathname': 'str',
            'query_string': 'str'
        }

        self.attribute_map = {
            'url': 'url',
            'title': 'title',
            'domain': 'domain',
            'fragment': 'fragment',
            'hostname': 'hostname',
            'keywords': 'keywords',
            'lang': 'lang',
            'pathname': 'pathname',
            'query_string': 'queryString'
        }

        self._url = None
        self._title = None
        self._domain = None
        self._fragment = None
        self._hostname = None
        self._keywords = None
        self._lang = None
        self._pathname = None
        self._query_string = None

    @property
    def url(self) -> str:
        """
        Gets the url of this ResponsePage.
        The page URL.

        :return: The url of this ResponsePage.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str) -> None:
        """
        Sets the url of this ResponsePage.
        The page URL.

        :param url: The url of this ResponsePage.
        :type: str
        """
        

        self._url = url

    @property
    def title(self) -> str:
        """
        Gets the title of this ResponsePage.
        Title of the page.

        :return: The title of this ResponsePage.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this ResponsePage.
        Title of the page.

        :param title: The title of this ResponsePage.
        :type: str
        """
        

        self._title = title

    @property
    def domain(self) -> str:
        """
        Gets the domain of this ResponsePage.
        Domain of the page's URL.

        :return: The domain of this ResponsePage.
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain: str) -> None:
        """
        Sets the domain of this ResponsePage.
        Domain of the page's URL.

        :param domain: The domain of this ResponsePage.
        :type: str
        """
        

        self._domain = domain

    @property
    def fragment(self) -> str:
        """
        Gets the fragment of this ResponsePage.
        Fragment or hash of the page's URL.

        :return: The fragment of this ResponsePage.
        :rtype: str
        """
        return self._fragment

    @fragment.setter
    def fragment(self, fragment: str) -> None:
        """
        Sets the fragment of this ResponsePage.
        Fragment or hash of the page's URL.

        :param fragment: The fragment of this ResponsePage.
        :type: str
        """
        

        self._fragment = fragment

    @property
    def hostname(self) -> str:
        """
        Gets the hostname of this ResponsePage.
        Hostname of the page's URL.

        :return: The hostname of this ResponsePage.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname: str) -> None:
        """
        Sets the hostname of this ResponsePage.
        Hostname of the page's URL.

        :param hostname: The hostname of this ResponsePage.
        :type: str
        """
        

        self._hostname = hostname

    @property
    def keywords(self) -> str:
        """
        Gets the keywords of this ResponsePage.
        Keywords from the HTML <meta> tag of the page.

        :return: The keywords of this ResponsePage.
        :rtype: str
        """
        return self._keywords

    @keywords.setter
    def keywords(self, keywords: str) -> None:
        """
        Sets the keywords of this ResponsePage.
        Keywords from the HTML <meta> tag of the page.

        :param keywords: The keywords of this ResponsePage.
        :type: str
        """
        

        self._keywords = keywords

    @property
    def lang(self) -> str:
        """
        Gets the lang of this ResponsePage.
        ISO 639-1 language code for the page as defined in the <html> tag.

        :return: The lang of this ResponsePage.
        :rtype: str
        """
        return self._lang

    @lang.setter
    def lang(self, lang: str) -> None:
        """
        Sets the lang of this ResponsePage.
        ISO 639-1 language code for the page as defined in the <html> tag.

        :param lang: The lang of this ResponsePage.
        :type: str
        """
        

        self._lang = lang

    @property
    def pathname(self) -> str:
        """
        Gets the pathname of this ResponsePage.
        Path name of the page for the event.

        :return: The pathname of this ResponsePage.
        :rtype: str
        """
        return self._pathname

    @pathname.setter
    def pathname(self, pathname: str) -> None:
        """
        Sets the pathname of this ResponsePage.
        Path name of the page for the event.

        :param pathname: The pathname of this ResponsePage.
        :type: str
        """
        

        self._pathname = pathname

    @property
    def query_string(self) -> str:
        """
        Gets the query_string of this ResponsePage.
        Query string that is passed to the page in the current event.

        :return: The query_string of this ResponsePage.
        :rtype: str
        """
        return self._query_string

    @query_string.setter
    def query_string(self, query_string: str) -> None:
        """
        Sets the query_string of this ResponsePage.
        Query string that is passed to the page in the current event.

        :param query_string: The query_string of this ResponsePage.
        :type: str
        """
        

        self._query_string = query_string

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

