# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class RequestPage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RequestPage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'url': 'str',
            'title': 'str',
            'keywords': 'str',
            'lang': 'str'
        }

        self.attribute_map = {
            'url': 'url',
            'title': 'title',
            'keywords': 'keywords',
            'lang': 'lang'
        }

        self._url = None
        self._title = None
        self._keywords = None
        self._lang = None

    @property
    def url(self) -> str:
        """
        Gets the url of this RequestPage.
        The page URL.

        :return: The url of this RequestPage.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str) -> None:
        """
        Sets the url of this RequestPage.
        The page URL.

        :param url: The url of this RequestPage.
        :type: str
        """
        

        self._url = url

    @property
    def title(self) -> str:
        """
        Gets the title of this RequestPage.
        Title of the page.

        :return: The title of this RequestPage.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this RequestPage.
        Title of the page.

        :param title: The title of this RequestPage.
        :type: str
        """
        

        self._title = title

    @property
    def keywords(self) -> str:
        """
        Gets the keywords of this RequestPage.
        Keywords from the HTML <meta> tag of the page.

        :return: The keywords of this RequestPage.
        :rtype: str
        """
        return self._keywords

    @keywords.setter
    def keywords(self, keywords: str) -> None:
        """
        Sets the keywords of this RequestPage.
        Keywords from the HTML <meta> tag of the page.

        :param keywords: The keywords of this RequestPage.
        :type: str
        """
        

        self._keywords = keywords

    @property
    def lang(self) -> str:
        """
        Gets the lang of this RequestPage.
        ISO 639-1 language code for the page as defined in the <html> tag.

        :return: The lang of this RequestPage.
        :rtype: str
        """
        return self._lang

    @lang.setter
    def lang(self, lang: str) -> None:
        """
        Sets the lang of this RequestPage.
        ISO 639-1 language code for the page as defined in the <html> tag.

        :param lang: The lang of this RequestPage.
        :type: str
        """
        

        self._lang = lang

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

