# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Alteration
    from . import NextOccurrenceDetails
    from . import Pattern
    from . import Range

class Reoccurrence(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Reoccurrence - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'start': 'str',
            'end': 'str',
            'time_zone': 'str',
            'pattern': 'Pattern',
            'range': 'Range',
            'alterations': 'list[Alteration]',
            'next_occurrence_details': 'NextOccurrenceDetails'
        }

        self.attribute_map = {
            'id': 'id',
            'start': 'start',
            'end': 'end',
            'time_zone': 'timeZone',
            'pattern': 'pattern',
            'range': 'range',
            'alterations': 'alterations',
            'next_occurrence_details': 'nextOccurrenceDetails'
        }

        self._id = None
        self._start = None
        self._end = None
        self._time_zone = None
        self._pattern = None
        self._range = None
        self._alterations = None
        self._next_occurrence_details = None

    @property
    def id(self) -> str:
        """
        Gets the id of this Reoccurrence.


        :return: The id of this Reoccurrence.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this Reoccurrence.


        :param id: The id of this Reoccurrence.
        :type: str
        """
        

        self._id = id

    @property
    def start(self) -> str:
        """
        Gets the start of this Reoccurrence.
        The start date time of the initial occurrence as an ISO-8601 string in the format YYYY-MM-DDThh:mm:ss

        :return: The start of this Reoccurrence.
        :rtype: str
        """
        return self._start

    @start.setter
    def start(self, start: str) -> None:
        """
        Sets the start of this Reoccurrence.
        The start date time of the initial occurrence as an ISO-8601 string in the format YYYY-MM-DDThh:mm:ss

        :param start: The start of this Reoccurrence.
        :type: str
        """
        

        self._start = start

    @property
    def end(self) -> str:
        """
        Gets the end of this Reoccurrence.
        The end date time of the initial occurrence as an ISO-8601 string in the format YYYY-MM-DDThh:mm:ss

        :return: The end of this Reoccurrence.
        :rtype: str
        """
        return self._end

    @end.setter
    def end(self, end: str) -> None:
        """
        Sets the end of this Reoccurrence.
        The end date time of the initial occurrence as an ISO-8601 string in the format YYYY-MM-DDThh:mm:ss

        :param end: The end of this Reoccurrence.
        :type: str
        """
        

        self._end = end

    @property
    def time_zone(self) -> str:
        """
        Gets the time_zone of this Reoccurrence.
        The time zone for the recurrence. The time zone of the recurrence is determined by prioritizing the recurrence's time zone if specified, then the schedule's time zone if set, and finally defaulting to UTC if neither defines a time zone. See here for a list of valid time zones https://www.iana.org/time-zones

        :return: The time_zone of this Reoccurrence.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone: str) -> None:
        """
        Sets the time_zone of this Reoccurrence.
        The time zone for the recurrence. The time zone of the recurrence is determined by prioritizing the recurrence's time zone if specified, then the schedule's time zone if set, and finally defaulting to UTC if neither defines a time zone. See here for a list of valid time zones https://www.iana.org/time-zones

        :param time_zone: The time_zone of this Reoccurrence.
        :type: str
        """
        

        self._time_zone = time_zone

    @property
    def pattern(self) -> 'Pattern':
        """
        Gets the pattern of this Reoccurrence.
        The schedule pattern e.g.: Daily/Weekly

        :return: The pattern of this Reoccurrence.
        :rtype: Pattern
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern: 'Pattern') -> None:
        """
        Sets the pattern of this Reoccurrence.
        The schedule pattern e.g.: Daily/Weekly

        :param pattern: The pattern of this Reoccurrence.
        :type: Pattern
        """
        

        self._pattern = pattern

    @property
    def range(self) -> 'Range':
        """
        Gets the range of this Reoccurrence.
        The schedule range e.g.: EndDate/NoEnd/Numbered

        :return: The range of this Reoccurrence.
        :rtype: Range
        """
        return self._range

    @range.setter
    def range(self, range: 'Range') -> None:
        """
        Sets the range of this Reoccurrence.
        The schedule range e.g.: EndDate/NoEnd/Numbered

        :param range: The range of this Reoccurrence.
        :type: Range
        """
        

        self._range = range

    @property
    def alterations(self) -> List['Alteration']:
        """
        Gets the alterations of this Reoccurrence.
        Modifications to the original recurrence schedule (Exclusions/Inclusions)

        :return: The alterations of this Reoccurrence.
        :rtype: list[Alteration]
        """
        return self._alterations

    @alterations.setter
    def alterations(self, alterations: List['Alteration']) -> None:
        """
        Sets the alterations of this Reoccurrence.
        Modifications to the original recurrence schedule (Exclusions/Inclusions)

        :param alterations: The alterations of this Reoccurrence.
        :type: list[Alteration]
        """
        

        self._alterations = alterations

    @property
    def next_occurrence_details(self) -> 'NextOccurrenceDetails':
        """
        Gets the next_occurrence_details of this Reoccurrence.
        The next occurrence details for the next start and end occurrences for the recurrence

        :return: The next_occurrence_details of this Reoccurrence.
        :rtype: NextOccurrenceDetails
        """
        return self._next_occurrence_details

    @next_occurrence_details.setter
    def next_occurrence_details(self, next_occurrence_details: 'NextOccurrenceDetails') -> None:
        """
        Sets the next_occurrence_details of this Reoccurrence.
        The next occurrence details for the next start and end occurrences for the recurrence

        :param next_occurrence_details: The next_occurrence_details of this Reoccurrence.
        :type: NextOccurrenceDetails
        """
        

        self._next_occurrence_details = next_occurrence_details

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

