# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import RecurrenceEndSettings
    from . import RecurrencePeriod

class RecurrenceSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RecurrenceSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'recurrence_period': 'RecurrencePeriod',
            'minimum_time_between_occurrences': 'RecurrencePeriod',
            'end_after': 'RecurrenceEndSettings'
        }

        self.attribute_map = {
            'recurrence_period': 'recurrencePeriod',
            'minimum_time_between_occurrences': 'minimumTimeBetweenOccurrences',
            'end_after': 'endAfter'
        }

        self._recurrence_period = None
        self._minimum_time_between_occurrences = None
        self._end_after = None

    @property
    def recurrence_period(self) -> 'RecurrencePeriod':
        """
        Gets the recurrence_period of this RecurrenceSettings.
        The recurrence period of the activity plan

        :return: The recurrence_period of this RecurrenceSettings.
        :rtype: RecurrencePeriod
        """
        return self._recurrence_period

    @recurrence_period.setter
    def recurrence_period(self, recurrence_period: 'RecurrencePeriod') -> None:
        """
        Sets the recurrence_period of this RecurrenceSettings.
        The recurrence period of the activity plan

        :param recurrence_period: The recurrence_period of this RecurrenceSettings.
        :type: RecurrencePeriod
        """
        

        self._recurrence_period = recurrence_period

    @property
    def minimum_time_between_occurrences(self) -> 'RecurrencePeriod':
        """
        Gets the minimum_time_between_occurrences of this RecurrenceSettings.
        Constraint indicating the minimum time in hours between recurrences of the activity plan

        :return: The minimum_time_between_occurrences of this RecurrenceSettings.
        :rtype: RecurrencePeriod
        """
        return self._minimum_time_between_occurrences

    @minimum_time_between_occurrences.setter
    def minimum_time_between_occurrences(self, minimum_time_between_occurrences: 'RecurrencePeriod') -> None:
        """
        Sets the minimum_time_between_occurrences of this RecurrenceSettings.
        Constraint indicating the minimum time in hours between recurrences of the activity plan

        :param minimum_time_between_occurrences: The minimum_time_between_occurrences of this RecurrenceSettings.
        :type: RecurrencePeriod
        """
        

        self._minimum_time_between_occurrences = minimum_time_between_occurrences

    @property
    def end_after(self) -> 'RecurrenceEndSettings':
        """
        Gets the end_after of this RecurrenceSettings.
        Settings controlling when to end the recurrence for the activity plan

        :return: The end_after of this RecurrenceSettings.
        :rtype: RecurrenceEndSettings
        """
        return self._end_after

    @end_after.setter
    def end_after(self, end_after: 'RecurrenceEndSettings') -> None:
        """
        Sets the end_after of this RecurrenceSettings.
        Settings controlling when to end the recurrence for the activity plan

        :param end_after: The end_after of this RecurrenceSettings.
        :type: RecurrenceEndSettings
        """
        

        self._end_after = end_after

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

