# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class RecordersState(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RecordersState - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'adhoc_state': 'str',
            'customer_experience_state': 'str',
            'agent_experience_state': 'str'
        }

        self.attribute_map = {
            'adhoc_state': 'adhocState',
            'customer_experience_state': 'customerExperienceState',
            'agent_experience_state': 'agentExperienceState'
        }

        self._adhoc_state = None
        self._customer_experience_state = None
        self._agent_experience_state = None

    @property
    def adhoc_state(self) -> str:
        """
        Gets the adhoc_state of this RecordersState.
        Indicates the state of the adhoc recorder.

        :return: The adhoc_state of this RecordersState.
        :rtype: str
        """
        return self._adhoc_state

    @adhoc_state.setter
    def adhoc_state(self, adhoc_state: str) -> None:
        """
        Sets the adhoc_state of this RecordersState.
        Indicates the state of the adhoc recorder.

        :param adhoc_state: The adhoc_state of this RecordersState.
        :type: str
        """
        if isinstance(adhoc_state, int):
            adhoc_state = str(adhoc_state)
        allowed_values = ["ACTIVE", "PAUSED", "NONE"]
        if adhoc_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for adhoc_state -> " + adhoc_state)
            self._adhoc_state = "outdated_sdk_version"
        else:
            self._adhoc_state = adhoc_state

    @property
    def customer_experience_state(self) -> str:
        """
        Gets the customer_experience_state of this RecordersState.
        Indicates the state of the customer experience recorder.

        :return: The customer_experience_state of this RecordersState.
        :rtype: str
        """
        return self._customer_experience_state

    @customer_experience_state.setter
    def customer_experience_state(self, customer_experience_state: str) -> None:
        """
        Sets the customer_experience_state of this RecordersState.
        Indicates the state of the customer experience recorder.

        :param customer_experience_state: The customer_experience_state of this RecordersState.
        :type: str
        """
        if isinstance(customer_experience_state, int):
            customer_experience_state = str(customer_experience_state)
        allowed_values = ["ACTIVE", "PAUSED", "NONE"]
        if customer_experience_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for customer_experience_state -> " + customer_experience_state)
            self._customer_experience_state = "outdated_sdk_version"
        else:
            self._customer_experience_state = customer_experience_state

    @property
    def agent_experience_state(self) -> str:
        """
        Gets the agent_experience_state of this RecordersState.
        Indicates the state of the agent experience recorder.

        :return: The agent_experience_state of this RecordersState.
        :rtype: str
        """
        return self._agent_experience_state

    @agent_experience_state.setter
    def agent_experience_state(self, agent_experience_state: str) -> None:
        """
        Sets the agent_experience_state of this RecordersState.
        Indicates the state of the agent experience recorder.

        :param agent_experience_state: The agent_experience_state of this RecordersState.
        :type: str
        """
        if isinstance(agent_experience_state, int):
            agent_experience_state = str(agent_experience_state)
        allowed_values = ["ACTIVE", "PAUSED", "NONE"]
        if agent_experience_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for agent_experience_state -> " + agent_experience_state)
            self._agent_experience_state = "outdated_sdk_version"
        else:
            self._agent_experience_state = agent_experience_state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

