# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserReference

class Recognition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Recognition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'recipient': 'UserReference',
            'created_by': 'UserReference',
            'date_created': 'datetime',
            'type': 'str',
            'title': 'str',
            'note': 'str',
            'context_type': 'str',
            'context_id': 'str',
            'date_displayed': 'datetime',
            'date_acknowledged': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'recipient': 'recipient',
            'created_by': 'createdBy',
            'date_created': 'dateCreated',
            'type': 'type',
            'title': 'title',
            'note': 'note',
            'context_type': 'contextType',
            'context_id': 'contextId',
            'date_displayed': 'dateDisplayed',
            'date_acknowledged': 'dateAcknowledged',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._recipient = None
        self._created_by = None
        self._date_created = None
        self._type = None
        self._title = None
        self._note = None
        self._context_type = None
        self._context_id = None
        self._date_displayed = None
        self._date_acknowledged = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this Recognition.
        The globally unique identifier for the object.

        :return: The id of this Recognition.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this Recognition.
        The globally unique identifier for the object.

        :param id: The id of this Recognition.
        :type: str
        """
        

        self._id = id

    @property
    def recipient(self) -> 'UserReference':
        """
        Gets the recipient of this Recognition.
        The recipient of the recognition

        :return: The recipient of this Recognition.
        :rtype: UserReference
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient: 'UserReference') -> None:
        """
        Sets the recipient of this Recognition.
        The recipient of the recognition

        :param recipient: The recipient of this Recognition.
        :type: UserReference
        """
        

        self._recipient = recipient

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this Recognition.
        The creator of the recognition

        :return: The created_by of this Recognition.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this Recognition.
        The creator of the recognition

        :param created_by: The created_by of this Recognition.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this Recognition.
        The creation date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this Recognition.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this Recognition.
        The creation date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this Recognition.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def type(self) -> str:
        """
        Gets the type of this Recognition.
        The type of recognition

        :return: The type of this Recognition.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this Recognition.
        The type of recognition

        :param type: The type of this Recognition.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["ThankYou", "Congratulations", "HighPerformance", "CompanyValues"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def title(self) -> str:
        """
        Gets the title of this Recognition.
        The recognition title

        :return: The title of this Recognition.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this Recognition.
        The recognition title

        :param title: The title of this Recognition.
        :type: str
        """
        

        self._title = title

    @property
    def note(self) -> str:
        """
        Gets the note of this Recognition.
        The recognition note

        :return: The note of this Recognition.
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note: str) -> None:
        """
        Sets the note of this Recognition.
        The recognition note

        :param note: The note of this Recognition.
        :type: str
        """
        

        self._note = note

    @property
    def context_type(self) -> str:
        """
        Gets the context_type of this Recognition.
        The context type (optional)

        :return: The context_type of this Recognition.
        :rtype: str
        """
        return self._context_type

    @context_type.setter
    def context_type(self, context_type: str) -> None:
        """
        Sets the context_type of this Recognition.
        The context type (optional)

        :param context_type: The context_type of this Recognition.
        :type: str
        """
        if isinstance(context_type, int):
            context_type = str(context_type)
        allowed_values = ["Interaction", "Insights", "Development", "Scorecard"]
        if context_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for context_type -> " + context_type)
            self._context_type = "outdated_sdk_version"
        else:
            self._context_type = context_type

    @property
    def context_id(self) -> str:
        """
        Gets the context_id of this Recognition.
        The context id (optional)

        :return: The context_id of this Recognition.
        :rtype: str
        """
        return self._context_id

    @context_id.setter
    def context_id(self, context_id: str) -> None:
        """
        Sets the context_id of this Recognition.
        The context id (optional)

        :param context_id: The context_id of this Recognition.
        :type: str
        """
        

        self._context_id = context_id

    @property
    def date_displayed(self) -> datetime:
        """
        Gets the date_displayed of this Recognition.
        The displayed date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_displayed of this Recognition.
        :rtype: datetime
        """
        return self._date_displayed

    @date_displayed.setter
    def date_displayed(self, date_displayed: datetime) -> None:
        """
        Sets the date_displayed of this Recognition.
        The displayed date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_displayed: The date_displayed of this Recognition.
        :type: datetime
        """
        

        self._date_displayed = date_displayed

    @property
    def date_acknowledged(self) -> datetime:
        """
        Gets the date_acknowledged of this Recognition.
        The acknowledged date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_acknowledged of this Recognition.
        :rtype: datetime
        """
        return self._date_acknowledged

    @date_acknowledged.setter
    def date_acknowledged(self, date_acknowledged: datetime) -> None:
        """
        Sets the date_acknowledged of this Recognition.
        The acknowledged date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_acknowledged: The date_acknowledged of this Recognition.
        :type: datetime
        """
        

        self._date_acknowledged = date_acknowledged

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this Recognition.
        The URI for this object

        :return: The self_uri of this Recognition.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this Recognition.
        The URI for this object

        :param self_uri: The self_uri of this Recognition.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

