# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import QueueConversationSocialExpressionEventTopicConversationDivisionMembership
    from . import QueueConversationSocialExpressionEventTopicParticipant
    from . import QueueConversationSocialExpressionEventTopicTransferResponse

class QueueConversationSocialExpressionEventTopicConversation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QueueConversationSocialExpressionEventTopicConversation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'max_participants': 'int',
            'participants': 'list[QueueConversationSocialExpressionEventTopicParticipant]',
            'recent_transfers': 'list[QueueConversationSocialExpressionEventTopicTransferResponse]',
            'recording_state': 'str',
            'address': 'str',
            'external_tag': 'str',
            'utilization_label_id': 'str',
            'secure_pause': 'bool',
            'divisions': 'list[QueueConversationSocialExpressionEventTopicConversationDivisionMembership]'
        }

        self.attribute_map = {
            'id': 'id',
            'max_participants': 'maxParticipants',
            'participants': 'participants',
            'recent_transfers': 'recentTransfers',
            'recording_state': 'recordingState',
            'address': 'address',
            'external_tag': 'externalTag',
            'utilization_label_id': 'utilizationLabelId',
            'secure_pause': 'securePause',
            'divisions': 'divisions'
        }

        self._id = None
        self._max_participants = None
        self._participants = None
        self._recent_transfers = None
        self._recording_state = None
        self._address = None
        self._external_tag = None
        self._utilization_label_id = None
        self._secure_pause = None
        self._divisions = None

    @property
    def id(self) -> str:
        """
        Gets the id of this QueueConversationSocialExpressionEventTopicConversation.


        :return: The id of this QueueConversationSocialExpressionEventTopicConversation.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this QueueConversationSocialExpressionEventTopicConversation.


        :param id: The id of this QueueConversationSocialExpressionEventTopicConversation.
        :type: str
        """
        

        self._id = id

    @property
    def max_participants(self) -> int:
        """
        Gets the max_participants of this QueueConversationSocialExpressionEventTopicConversation.


        :return: The max_participants of this QueueConversationSocialExpressionEventTopicConversation.
        :rtype: int
        """
        return self._max_participants

    @max_participants.setter
    def max_participants(self, max_participants: int) -> None:
        """
        Sets the max_participants of this QueueConversationSocialExpressionEventTopicConversation.


        :param max_participants: The max_participants of this QueueConversationSocialExpressionEventTopicConversation.
        :type: int
        """
        

        self._max_participants = max_participants

    @property
    def participants(self) -> List['QueueConversationSocialExpressionEventTopicParticipant']:
        """
        Gets the participants of this QueueConversationSocialExpressionEventTopicConversation.


        :return: The participants of this QueueConversationSocialExpressionEventTopicConversation.
        :rtype: list[QueueConversationSocialExpressionEventTopicParticipant]
        """
        return self._participants

    @participants.setter
    def participants(self, participants: List['QueueConversationSocialExpressionEventTopicParticipant']) -> None:
        """
        Sets the participants of this QueueConversationSocialExpressionEventTopicConversation.


        :param participants: The participants of this QueueConversationSocialExpressionEventTopicConversation.
        :type: list[QueueConversationSocialExpressionEventTopicParticipant]
        """
        

        self._participants = participants

    @property
    def recent_transfers(self) -> List['QueueConversationSocialExpressionEventTopicTransferResponse']:
        """
        Gets the recent_transfers of this QueueConversationSocialExpressionEventTopicConversation.


        :return: The recent_transfers of this QueueConversationSocialExpressionEventTopicConversation.
        :rtype: list[QueueConversationSocialExpressionEventTopicTransferResponse]
        """
        return self._recent_transfers

    @recent_transfers.setter
    def recent_transfers(self, recent_transfers: List['QueueConversationSocialExpressionEventTopicTransferResponse']) -> None:
        """
        Sets the recent_transfers of this QueueConversationSocialExpressionEventTopicConversation.


        :param recent_transfers: The recent_transfers of this QueueConversationSocialExpressionEventTopicConversation.
        :type: list[QueueConversationSocialExpressionEventTopicTransferResponse]
        """
        

        self._recent_transfers = recent_transfers

    @property
    def recording_state(self) -> str:
        """
        Gets the recording_state of this QueueConversationSocialExpressionEventTopicConversation.


        :return: The recording_state of this QueueConversationSocialExpressionEventTopicConversation.
        :rtype: str
        """
        return self._recording_state

    @recording_state.setter
    def recording_state(self, recording_state: str) -> None:
        """
        Sets the recording_state of this QueueConversationSocialExpressionEventTopicConversation.


        :param recording_state: The recording_state of this QueueConversationSocialExpressionEventTopicConversation.
        :type: str
        """
        

        self._recording_state = recording_state

    @property
    def address(self) -> str:
        """
        Gets the address of this QueueConversationSocialExpressionEventTopicConversation.


        :return: The address of this QueueConversationSocialExpressionEventTopicConversation.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address: str) -> None:
        """
        Sets the address of this QueueConversationSocialExpressionEventTopicConversation.


        :param address: The address of this QueueConversationSocialExpressionEventTopicConversation.
        :type: str
        """
        

        self._address = address

    @property
    def external_tag(self) -> str:
        """
        Gets the external_tag of this QueueConversationSocialExpressionEventTopicConversation.


        :return: The external_tag of this QueueConversationSocialExpressionEventTopicConversation.
        :rtype: str
        """
        return self._external_tag

    @external_tag.setter
    def external_tag(self, external_tag: str) -> None:
        """
        Sets the external_tag of this QueueConversationSocialExpressionEventTopicConversation.


        :param external_tag: The external_tag of this QueueConversationSocialExpressionEventTopicConversation.
        :type: str
        """
        

        self._external_tag = external_tag

    @property
    def utilization_label_id(self) -> str:
        """
        Gets the utilization_label_id of this QueueConversationSocialExpressionEventTopicConversation.


        :return: The utilization_label_id of this QueueConversationSocialExpressionEventTopicConversation.
        :rtype: str
        """
        return self._utilization_label_id

    @utilization_label_id.setter
    def utilization_label_id(self, utilization_label_id: str) -> None:
        """
        Sets the utilization_label_id of this QueueConversationSocialExpressionEventTopicConversation.


        :param utilization_label_id: The utilization_label_id of this QueueConversationSocialExpressionEventTopicConversation.
        :type: str
        """
        

        self._utilization_label_id = utilization_label_id

    @property
    def secure_pause(self) -> bool:
        """
        Gets the secure_pause of this QueueConversationSocialExpressionEventTopicConversation.


        :return: The secure_pause of this QueueConversationSocialExpressionEventTopicConversation.
        :rtype: bool
        """
        return self._secure_pause

    @secure_pause.setter
    def secure_pause(self, secure_pause: bool) -> None:
        """
        Sets the secure_pause of this QueueConversationSocialExpressionEventTopicConversation.


        :param secure_pause: The secure_pause of this QueueConversationSocialExpressionEventTopicConversation.
        :type: bool
        """
        

        self._secure_pause = secure_pause

    @property
    def divisions(self) -> List['QueueConversationSocialExpressionEventTopicConversationDivisionMembership']:
        """
        Gets the divisions of this QueueConversationSocialExpressionEventTopicConversation.


        :return: The divisions of this QueueConversationSocialExpressionEventTopicConversation.
        :rtype: list[QueueConversationSocialExpressionEventTopicConversationDivisionMembership]
        """
        return self._divisions

    @divisions.setter
    def divisions(self, divisions: List['QueueConversationSocialExpressionEventTopicConversationDivisionMembership']) -> None:
        """
        Sets the divisions of this QueueConversationSocialExpressionEventTopicConversation.


        :param divisions: The divisions of this QueueConversationSocialExpressionEventTopicConversation.
        :type: list[QueueConversationSocialExpressionEventTopicConversationDivisionMembership]
        """
        

        self._divisions = divisions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

