# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class QueueConversationCobrowseEventTopicLimit(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QueueConversationCobrowseEventTopicLimit - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'key': 'str',
            'namespace': 'str',
            'value': 'int',
            'documented': 'bool'
        }

        self.attribute_map = {
            'key': 'key',
            'namespace': 'namespace',
            'value': 'value',
            'documented': 'documented'
        }

        self._key = None
        self._namespace = None
        self._value = None
        self._documented = None

    @property
    def key(self) -> str:
        """
        Gets the key of this QueueConversationCobrowseEventTopicLimit.


        :return: The key of this QueueConversationCobrowseEventTopicLimit.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key: str) -> None:
        """
        Sets the key of this QueueConversationCobrowseEventTopicLimit.


        :param key: The key of this QueueConversationCobrowseEventTopicLimit.
        :type: str
        """
        

        self._key = key

    @property
    def namespace(self) -> str:
        """
        Gets the namespace of this QueueConversationCobrowseEventTopicLimit.


        :return: The namespace of this QueueConversationCobrowseEventTopicLimit.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace: str) -> None:
        """
        Sets the namespace of this QueueConversationCobrowseEventTopicLimit.


        :param namespace: The namespace of this QueueConversationCobrowseEventTopicLimit.
        :type: str
        """
        if isinstance(namespace, int):
            namespace = str(namespace)
        allowed_values = ["agent.assistant", "analytics.alerting", "analytics", "analytics.realtime", "analytics.reporting.settings", "architect", "audiohook", "audit", "auth.api", "authorization", "automation.testing", "bots", "bots.voice", "callback", "cobrowse", "content.management", "conversation", "dataactions", "datatables", "directory", "email", "event.orchestration", "external.contacts", "gcv", "gdpr", "groups", "historical.adherence", "infrastructureascode", "integrations", "intent.miner", "journey", "knowledge", "language.understanding", "learning", "limit.registry", "marketplace", "media.communications", "messaging", "notifications", "onboarding", "outbound", "platform.api", "predictive.routing", "presence", "quality", "recording", "response.management", "routing", "scim", "search", "secondary.automation.testing", "skills", "speech.and.text.analytics", "speech.integration", "supportability", "task.management", "telephony.configuration", "usage", "users", "web.deployments", "web.messaging", "webchat", "webhooks", "workforce.management"]
        if namespace.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for namespace -> " + namespace)
            self._namespace = "outdated_sdk_version"
        else:
            self._namespace = namespace

    @property
    def value(self) -> int:
        """
        Gets the value of this QueueConversationCobrowseEventTopicLimit.


        :return: The value of this QueueConversationCobrowseEventTopicLimit.
        :rtype: int
        """
        return self._value

    @value.setter
    def value(self, value: int) -> None:
        """
        Sets the value of this QueueConversationCobrowseEventTopicLimit.


        :param value: The value of this QueueConversationCobrowseEventTopicLimit.
        :type: int
        """
        

        self._value = value

    @property
    def documented(self) -> bool:
        """
        Gets the documented of this QueueConversationCobrowseEventTopicLimit.


        :return: The documented of this QueueConversationCobrowseEventTopicLimit.
        :rtype: bool
        """
        return self._documented

    @documented.setter
    def documented(self, documented: bool) -> None:
        """
        Sets the documented of this QueueConversationCobrowseEventTopicLimit.


        :param documented: The documented of this QueueConversationCobrowseEventTopicLimit.
        :type: bool
        """
        

        self._documented = documented

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

