# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import QueueConversationCallbackEventTopicCallbackMediaParticipant
    from . import QueueConversationCallbackEventTopicConversationDivisionMembership

class QueueConversationCallbackEventTopicCallbackConversation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QueueConversationCallbackEventTopicCallbackConversation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'participants': 'list[QueueConversationCallbackEventTopicCallbackMediaParticipant]',
            'other_media_uris': 'list[str]',
            'address': 'str',
            'utilization_label_id': 'str',
            'divisions': 'list[QueueConversationCallbackEventTopicConversationDivisionMembership]'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'participants': 'participants',
            'other_media_uris': 'otherMediaUris',
            'address': 'address',
            'utilization_label_id': 'utilizationLabelId',
            'divisions': 'divisions'
        }

        self._id = None
        self._name = None
        self._participants = None
        self._other_media_uris = None
        self._address = None
        self._utilization_label_id = None
        self._divisions = None

    @property
    def id(self) -> str:
        """
        Gets the id of this QueueConversationCallbackEventTopicCallbackConversation.


        :return: The id of this QueueConversationCallbackEventTopicCallbackConversation.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this QueueConversationCallbackEventTopicCallbackConversation.


        :param id: The id of this QueueConversationCallbackEventTopicCallbackConversation.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this QueueConversationCallbackEventTopicCallbackConversation.


        :return: The name of this QueueConversationCallbackEventTopicCallbackConversation.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this QueueConversationCallbackEventTopicCallbackConversation.


        :param name: The name of this QueueConversationCallbackEventTopicCallbackConversation.
        :type: str
        """
        

        self._name = name

    @property
    def participants(self) -> List['QueueConversationCallbackEventTopicCallbackMediaParticipant']:
        """
        Gets the participants of this QueueConversationCallbackEventTopicCallbackConversation.


        :return: The participants of this QueueConversationCallbackEventTopicCallbackConversation.
        :rtype: list[QueueConversationCallbackEventTopicCallbackMediaParticipant]
        """
        return self._participants

    @participants.setter
    def participants(self, participants: List['QueueConversationCallbackEventTopicCallbackMediaParticipant']) -> None:
        """
        Sets the participants of this QueueConversationCallbackEventTopicCallbackConversation.


        :param participants: The participants of this QueueConversationCallbackEventTopicCallbackConversation.
        :type: list[QueueConversationCallbackEventTopicCallbackMediaParticipant]
        """
        

        self._participants = participants

    @property
    def other_media_uris(self) -> List[str]:
        """
        Gets the other_media_uris of this QueueConversationCallbackEventTopicCallbackConversation.


        :return: The other_media_uris of this QueueConversationCallbackEventTopicCallbackConversation.
        :rtype: list[str]
        """
        return self._other_media_uris

    @other_media_uris.setter
    def other_media_uris(self, other_media_uris: List[str]) -> None:
        """
        Sets the other_media_uris of this QueueConversationCallbackEventTopicCallbackConversation.


        :param other_media_uris: The other_media_uris of this QueueConversationCallbackEventTopicCallbackConversation.
        :type: list[str]
        """
        

        self._other_media_uris = other_media_uris

    @property
    def address(self) -> str:
        """
        Gets the address of this QueueConversationCallbackEventTopicCallbackConversation.


        :return: The address of this QueueConversationCallbackEventTopicCallbackConversation.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address: str) -> None:
        """
        Sets the address of this QueueConversationCallbackEventTopicCallbackConversation.


        :param address: The address of this QueueConversationCallbackEventTopicCallbackConversation.
        :type: str
        """
        

        self._address = address

    @property
    def utilization_label_id(self) -> str:
        """
        Gets the utilization_label_id of this QueueConversationCallbackEventTopicCallbackConversation.


        :return: The utilization_label_id of this QueueConversationCallbackEventTopicCallbackConversation.
        :rtype: str
        """
        return self._utilization_label_id

    @utilization_label_id.setter
    def utilization_label_id(self, utilization_label_id: str) -> None:
        """
        Sets the utilization_label_id of this QueueConversationCallbackEventTopicCallbackConversation.


        :param utilization_label_id: The utilization_label_id of this QueueConversationCallbackEventTopicCallbackConversation.
        :type: str
        """
        

        self._utilization_label_id = utilization_label_id

    @property
    def divisions(self) -> List['QueueConversationCallbackEventTopicConversationDivisionMembership']:
        """
        Gets the divisions of this QueueConversationCallbackEventTopicCallbackConversation.


        :return: The divisions of this QueueConversationCallbackEventTopicCallbackConversation.
        :rtype: list[QueueConversationCallbackEventTopicConversationDivisionMembership]
        """
        return self._divisions

    @divisions.setter
    def divisions(self, divisions: List['QueueConversationCallbackEventTopicConversationDivisionMembership']) -> None:
        """
        Sets the divisions of this QueueConversationCallbackEventTopicCallbackConversation.


        :param divisions: The divisions of this QueueConversationCallbackEventTopicCallbackConversation.
        :type: list[QueueConversationCallbackEventTopicConversationDivisionMembership]
        """
        

        self._divisions = divisions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

