# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PreprocessingRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PreprocessingRule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'find': 'str',
            'replace_with': 'str',
            'pcGlobal': 'bool',
            'ignore_case': 'bool'
        }

        self.attribute_map = {
            'find': 'find',
            'replace_with': 'replaceWith',
            'pcGlobal': 'global',
            'ignore_case': 'ignoreCase'
        }

        self._find = None
        self._replace_with = None
        self._pcGlobal = None
        self._ignore_case = None

    @property
    def find(self) -> str:
        """
        Gets the find of this PreprocessingRule.
        The regular expression to which file lines are to be matched.

        :return: The find of this PreprocessingRule.
        :rtype: str
        """
        return self._find

    @find.setter
    def find(self, find: str) -> None:
        """
        Sets the find of this PreprocessingRule.
        The regular expression to which file lines are to be matched.

        :param find: The find of this PreprocessingRule.
        :type: str
        """
        

        self._find = find

    @property
    def replace_with(self) -> str:
        """
        Gets the replace_with of this PreprocessingRule.
        The string to be substituted for each match.

        :return: The replace_with of this PreprocessingRule.
        :rtype: str
        """
        return self._replace_with

    @replace_with.setter
    def replace_with(self, replace_with: str) -> None:
        """
        Sets the replace_with of this PreprocessingRule.
        The string to be substituted for each match.

        :param replace_with: The replace_with of this PreprocessingRule.
        :type: str
        """
        

        self._replace_with = replace_with

    @property
    def pcGlobal(self) -> bool:
        """
        Gets the pcGlobal of this PreprocessingRule.
        Replaces all matching substrings in every line.

        :return: The pcGlobal of this PreprocessingRule.
        :rtype: bool
        """
        return self._pcGlobal

    @pcGlobal.setter
    def pcGlobal(self, pcGlobal: bool) -> None:
        """
        Sets the pcGlobal of this PreprocessingRule.
        Replaces all matching substrings in every line.

        :param pcGlobal: The pcGlobal of this PreprocessingRule.
        :type: bool
        """
        

        self._pcGlobal = pcGlobal

    @property
    def ignore_case(self) -> bool:
        """
        Gets the ignore_case of this PreprocessingRule.
        Enables case-insensitive matching

        :return: The ignore_case of this PreprocessingRule.
        :rtype: bool
        """
        return self._ignore_case

    @ignore_case.setter
    def ignore_case(self, ignore_case: bool) -> None:
        """
        Sets the ignore_case of this PreprocessingRule.
        Enables case-insensitive matching

        :param ignore_case: The ignore_case of this PreprocessingRule.
        :type: bool
        """
        

        self._ignore_case = ignore_case

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

