# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import PredictorModelFeature

class PredictorModel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PredictorModel - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'kpi': 'str',
            'queues': 'list[AddressableEntityRef]',
            'date_created': 'datetime',
            'date_trained': 'datetime',
            'media_type': 'str',
            'features': 'list[PredictorModelFeature]'
        }

        self.attribute_map = {
            'id': 'id',
            'kpi': 'kpi',
            'queues': 'queues',
            'date_created': 'dateCreated',
            'date_trained': 'dateTrained',
            'media_type': 'mediaType',
            'features': 'features'
        }

        self._id = None
        self._kpi = None
        self._queues = None
        self._date_created = None
        self._date_trained = None
        self._media_type = None
        self._features = None

    @property
    def id(self) -> str:
        """
        Gets the id of this PredictorModel.
        The globally unique identifier for the object.

        :return: The id of this PredictorModel.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this PredictorModel.
        The globally unique identifier for the object.

        :param id: The id of this PredictorModel.
        :type: str
        """
        

        self._id = id

    @property
    def kpi(self) -> str:
        """
        Gets the kpi of this PredictorModel.
        The key performance indicator used in the model.

        :return: The kpi of this PredictorModel.
        :rtype: str
        """
        return self._kpi

    @kpi.setter
    def kpi(self, kpi: str) -> None:
        """
        Sets the kpi of this PredictorModel.
        The key performance indicator used in the model.

        :param kpi: The kpi of this PredictorModel.
        :type: str
        """
        

        self._kpi = kpi

    @property
    def queues(self) -> List['AddressableEntityRef']:
        """
        Gets the queues of this PredictorModel.
        The List of Queues that are assessed for Predictive Routing.

        :return: The queues of this PredictorModel.
        :rtype: list[AddressableEntityRef]
        """
        return self._queues

    @queues.setter
    def queues(self, queues: List['AddressableEntityRef']) -> None:
        """
        Sets the queues of this PredictorModel.
        The List of Queues that are assessed for Predictive Routing.

        :param queues: The queues of this PredictorModel.
        :type: list[AddressableEntityRef]
        """
        

        self._queues = queues

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this PredictorModel.
        DateTime indicating when the model was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this PredictorModel.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this PredictorModel.
        DateTime indicating when the model was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this PredictorModel.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_trained(self) -> datetime:
        """
        Gets the date_trained of this PredictorModel.
        DateTime indicating when the model was last trained. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_trained of this PredictorModel.
        :rtype: datetime
        """
        return self._date_trained

    @date_trained.setter
    def date_trained(self, date_trained: datetime) -> None:
        """
        Sets the date_trained of this PredictorModel.
        DateTime indicating when the model was last trained. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_trained: The date_trained of this PredictorModel.
        :type: datetime
        """
        

        self._date_trained = date_trained

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this PredictorModel.
        The media type of the model.

        :return: The media_type of this PredictorModel.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this PredictorModel.
        The media type of the model.

        :param media_type: The media_type of this PredictorModel.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["voice", "email", "message"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def features(self) -> List['PredictorModelFeature']:
        """
        Gets the features of this PredictorModel.


        :return: The features of this PredictorModel.
        :rtype: list[PredictorModelFeature]
        """
        return self._features

    @features.setter
    def features(self, features: List['PredictorModelFeature']) -> None:
        """
        Sets the features of this PredictorModel.


        :param features: The features of this PredictorModel.
        :type: list[PredictorModelFeature]
        """
        

        self._features = features

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

