# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PlanningGroupOutputs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PlanningGroupOutputs - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'planning_group_id': 'str',
            'service_level_per_interval': 'list[float]',
            'occupancy_per_interval': 'list[float]',
            'average_speed_of_answer_seconds_per_interval': 'list[float]',
            'abandon_rate_per_interval': 'list[float]'
        }

        self.attribute_map = {
            'planning_group_id': 'planningGroupId',
            'service_level_per_interval': 'serviceLevelPerInterval',
            'occupancy_per_interval': 'occupancyPerInterval',
            'average_speed_of_answer_seconds_per_interval': 'averageSpeedOfAnswerSecondsPerInterval',
            'abandon_rate_per_interval': 'abandonRatePerInterval'
        }

        self._planning_group_id = None
        self._service_level_per_interval = None
        self._occupancy_per_interval = None
        self._average_speed_of_answer_seconds_per_interval = None
        self._abandon_rate_per_interval = None

    @property
    def planning_group_id(self) -> str:
        """
        Gets the planning_group_id of this PlanningGroupOutputs.
        The ID for for the associated planning group result

        :return: The planning_group_id of this PlanningGroupOutputs.
        :rtype: str
        """
        return self._planning_group_id

    @planning_group_id.setter
    def planning_group_id(self, planning_group_id: str) -> None:
        """
        Sets the planning_group_id of this PlanningGroupOutputs.
        The ID for for the associated planning group result

        :param planning_group_id: The planning_group_id of this PlanningGroupOutputs.
        :type: str
        """
        

        self._planning_group_id = planning_group_id

    @property
    def service_level_per_interval(self) -> List[float]:
        """
        Gets the service_level_per_interval of this PlanningGroupOutputs.
        List of Service Level percentage (0.0-100.0) results per interval

        :return: The service_level_per_interval of this PlanningGroupOutputs.
        :rtype: list[float]
        """
        return self._service_level_per_interval

    @service_level_per_interval.setter
    def service_level_per_interval(self, service_level_per_interval: List[float]) -> None:
        """
        Sets the service_level_per_interval of this PlanningGroupOutputs.
        List of Service Level percentage (0.0-100.0) results per interval

        :param service_level_per_interval: The service_level_per_interval of this PlanningGroupOutputs.
        :type: list[float]
        """
        

        self._service_level_per_interval = service_level_per_interval

    @property
    def occupancy_per_interval(self) -> List[float]:
        """
        Gets the occupancy_per_interval of this PlanningGroupOutputs.
        List of Occupancy percentage (0.0-100.0) results per interval

        :return: The occupancy_per_interval of this PlanningGroupOutputs.
        :rtype: list[float]
        """
        return self._occupancy_per_interval

    @occupancy_per_interval.setter
    def occupancy_per_interval(self, occupancy_per_interval: List[float]) -> None:
        """
        Sets the occupancy_per_interval of this PlanningGroupOutputs.
        List of Occupancy percentage (0.0-100.0) results per interval

        :param occupancy_per_interval: The occupancy_per_interval of this PlanningGroupOutputs.
        :type: list[float]
        """
        

        self._occupancy_per_interval = occupancy_per_interval

    @property
    def average_speed_of_answer_seconds_per_interval(self) -> List[float]:
        """
        Gets the average_speed_of_answer_seconds_per_interval of this PlanningGroupOutputs.
        List of Average Speed of Answer (in seconds) results per interval

        :return: The average_speed_of_answer_seconds_per_interval of this PlanningGroupOutputs.
        :rtype: list[float]
        """
        return self._average_speed_of_answer_seconds_per_interval

    @average_speed_of_answer_seconds_per_interval.setter
    def average_speed_of_answer_seconds_per_interval(self, average_speed_of_answer_seconds_per_interval: List[float]) -> None:
        """
        Sets the average_speed_of_answer_seconds_per_interval of this PlanningGroupOutputs.
        List of Average Speed of Answer (in seconds) results per interval

        :param average_speed_of_answer_seconds_per_interval: The average_speed_of_answer_seconds_per_interval of this PlanningGroupOutputs.
        :type: list[float]
        """
        

        self._average_speed_of_answer_seconds_per_interval = average_speed_of_answer_seconds_per_interval

    @property
    def abandon_rate_per_interval(self) -> List[float]:
        """
        Gets the abandon_rate_per_interval of this PlanningGroupOutputs.
        List of Abandon rate percentage (0.0-100.0) results per interval

        :return: The abandon_rate_per_interval of this PlanningGroupOutputs.
        :rtype: list[float]
        """
        return self._abandon_rate_per_interval

    @abandon_rate_per_interval.setter
    def abandon_rate_per_interval(self, abandon_rate_per_interval: List[float]) -> None:
        """
        Sets the abandon_rate_per_interval of this PlanningGroupOutputs.
        List of Abandon rate percentage (0.0-100.0) results per interval

        :param abandon_rate_per_interval: The abandon_rate_per_interval of this PlanningGroupOutputs.
        :type: list[float]
        """
        

        self._abandon_rate_per_interval = abandon_rate_per_interval

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

