# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PersistentConnectionChangeTopicErrorLocation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PersistentConnectionChangeTopicErrorLocation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'function': 'str',
            'file_id': 'str',
            'line': 'int'
        }

        self.attribute_map = {
            'function': 'function',
            'file_id': 'fileID',
            'line': 'line'
        }

        self._function = None
        self._file_id = None
        self._line = None

    @property
    def function(self) -> str:
        """
        Gets the function of this PersistentConnectionChangeTopicErrorLocation.


        :return: The function of this PersistentConnectionChangeTopicErrorLocation.
        :rtype: str
        """
        return self._function

    @function.setter
    def function(self, function: str) -> None:
        """
        Sets the function of this PersistentConnectionChangeTopicErrorLocation.


        :param function: The function of this PersistentConnectionChangeTopicErrorLocation.
        :type: str
        """
        

        self._function = function

    @property
    def file_id(self) -> str:
        """
        Gets the file_id of this PersistentConnectionChangeTopicErrorLocation.


        :return: The file_id of this PersistentConnectionChangeTopicErrorLocation.
        :rtype: str
        """
        return self._file_id

    @file_id.setter
    def file_id(self, file_id: str) -> None:
        """
        Sets the file_id of this PersistentConnectionChangeTopicErrorLocation.


        :param file_id: The file_id of this PersistentConnectionChangeTopicErrorLocation.
        :type: str
        """
        

        self._file_id = file_id

    @property
    def line(self) -> int:
        """
        Gets the line of this PersistentConnectionChangeTopicErrorLocation.


        :return: The line of this PersistentConnectionChangeTopicErrorLocation.
        :rtype: int
        """
        return self._line

    @line.setter
    def line(self, line: int) -> None:
        """
        Sets the line of this PersistentConnectionChangeTopicErrorLocation.


        :param line: The line of this PersistentConnectionChangeTopicErrorLocation.
        :type: int
        """
        

        self._line = line

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

