# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import MuAgentQueueTimeRequest

class PerformancePredictionUploadSchema(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PerformancePredictionUploadSchema - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'calculation_start_date': 'datetime',
            'on_queue_times': 'list[MuAgentQueueTimeRequest]'
        }

        self.attribute_map = {
            'calculation_start_date': 'calculationStartDate',
            'on_queue_times': 'onQueueTimes'
        }

        self._calculation_start_date = None
        self._on_queue_times = None

    @property
    def calculation_start_date(self) -> datetime:
        """
        Gets the calculation_start_date of this PerformancePredictionUploadSchema.
        Date as an ISO-8601 string, corresponding to the beginning of the performance prediction results

        :return: The calculation_start_date of this PerformancePredictionUploadSchema.
        :rtype: datetime
        """
        return self._calculation_start_date

    @calculation_start_date.setter
    def calculation_start_date(self, calculation_start_date: datetime) -> None:
        """
        Sets the calculation_start_date of this PerformancePredictionUploadSchema.
        Date as an ISO-8601 string, corresponding to the beginning of the performance prediction results

        :param calculation_start_date: The calculation_start_date of this PerformancePredictionUploadSchema.
        :type: datetime
        """
        

        self._calculation_start_date = calculation_start_date

    @property
    def on_queue_times(self) -> List['MuAgentQueueTimeRequest']:
        """
        Gets the on_queue_times of this PerformancePredictionUploadSchema.
        List of agent on queue times by management unit

        :return: The on_queue_times of this PerformancePredictionUploadSchema.
        :rtype: list[MuAgentQueueTimeRequest]
        """
        return self._on_queue_times

    @on_queue_times.setter
    def on_queue_times(self, on_queue_times: List['MuAgentQueueTimeRequest']) -> None:
        """
        Sets the on_queue_times of this PerformancePredictionUploadSchema.
        List of agent on queue times by management unit

        :param on_queue_times: The on_queue_times of this PerformancePredictionUploadSchema.
        :type: list[MuAgentQueueTimeRequest]
        """
        

        self._on_queue_times = on_queue_times

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

