# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import PerformancePredictionOutputs

class PerformancePredictionRecalculationResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PerformancePredictionRecalculationResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'operation_id': 'str',
            'download_url': 'str',
            'download_result': 'PerformancePredictionOutputs',
            'state': 'str'
        }

        self.attribute_map = {
            'operation_id': 'operationId',
            'download_url': 'downloadUrl',
            'download_result': 'downloadResult',
            'state': 'state'
        }

        self._operation_id = None
        self._download_url = None
        self._download_result = None
        self._state = None

    @property
    def operation_id(self) -> str:
        """
        Gets the operation_id of this PerformancePredictionRecalculationResponse.
        The operationId for which to listen

        :return: The operation_id of this PerformancePredictionRecalculationResponse.
        :rtype: str
        """
        return self._operation_id

    @operation_id.setter
    def operation_id(self, operation_id: str) -> None:
        """
        Sets the operation_id of this PerformancePredictionRecalculationResponse.
        The operationId for which to listen

        :param operation_id: The operation_id of this PerformancePredictionRecalculationResponse.
        :type: str
        """
        

        self._operation_id = operation_id

    @property
    def download_url(self) -> str:
        """
        Gets the download_url of this PerformancePredictionRecalculationResponse.
        The url to GET the results of the performance prediction. This field is populated only if query state is 'Complete'

        :return: The download_url of this PerformancePredictionRecalculationResponse.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url: str) -> None:
        """
        Sets the download_url of this PerformancePredictionRecalculationResponse.
        The url to GET the results of the performance prediction. This field is populated only if query state is 'Complete'

        :param download_url: The download_url of this PerformancePredictionRecalculationResponse.
        :type: str
        """
        

        self._download_url = download_url

    @property
    def download_result(self) -> 'PerformancePredictionOutputs':
        """
        Gets the download_result of this PerformancePredictionRecalculationResponse.
        Result will always come via downloadUrls; however the schema is included for documentation

        :return: The download_result of this PerformancePredictionRecalculationResponse.
        :rtype: PerformancePredictionOutputs
        """
        return self._download_result

    @download_result.setter
    def download_result(self, download_result: 'PerformancePredictionOutputs') -> None:
        """
        Sets the download_result of this PerformancePredictionRecalculationResponse.
        Result will always come via downloadUrls; however the schema is included for documentation

        :param download_result: The download_result of this PerformancePredictionRecalculationResponse.
        :type: PerformancePredictionOutputs
        """
        

        self._download_result = download_result

    @property
    def state(self) -> str:
        """
        Gets the state of this PerformancePredictionRecalculationResponse.
        The state of the performance prediction

        :return: The state of this PerformancePredictionRecalculationResponse.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this PerformancePredictionRecalculationResponse.
        The state of the performance prediction

        :param state: The state of this PerformancePredictionRecalculationResponse.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Processing", "Complete", "Error"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

