# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class Pattern(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Pattern - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'interval': 'int',
            'days_of_week': 'list[str]'
        }

        self.attribute_map = {
            'type': 'type',
            'interval': 'interval',
            'days_of_week': 'daysOfWeek'
        }

        self._type = None
        self._interval = None
        self._days_of_week = None

    @property
    def type(self) -> str:
        """
        Gets the type of this Pattern.
        Pattern type (Daily/Weekly)

        :return: The type of this Pattern.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this Pattern.
        Pattern type (Daily/Weekly)

        :param type: The type of this Pattern.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Daily", "Weekly"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def interval(self) -> int:
        """
        Gets the interval of this Pattern.
        The interval of days between the occurrences for Daily pattern type, and weeks between the occurrences for Weekly

        :return: The interval of this Pattern.
        :rtype: int
        """
        return self._interval

    @interval.setter
    def interval(self, interval: int) -> None:
        """
        Sets the interval of this Pattern.
        The interval of days between the occurrences for Daily pattern type, and weeks between the occurrences for Weekly

        :param interval: The interval of this Pattern.
        :type: int
        """
        

        self._interval = interval

    @property
    def days_of_week(self) -> List[str]:
        """
        Gets the days_of_week of this Pattern.
        The day(s) of week the occurrence should be repeated. Required to set for Weekly pattern type. E.g. [\"Monday\", \"Wednesday\"]

        :return: The days_of_week of this Pattern.
        :rtype: list[str]
        """
        return self._days_of_week

    @days_of_week.setter
    def days_of_week(self, days_of_week: List[str]) -> None:
        """
        Sets the days_of_week of this Pattern.
        The day(s) of week the occurrence should be repeated. Required to set for Weekly pattern type. E.g. [\"Monday\", \"Wednesday\"]

        :param days_of_week: The days_of_week of this Pattern.
        :type: list[str]
        """
        

        self._days_of_week = days_of_week

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

