# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import PredictorSchedule
    from . import PredictorWorkloadBalancing

class PatchPredictorRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PatchPredictorRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'routing_timeout_seconds': 'int',
            'schedule': 'PredictorSchedule',
            'workload_balancing_config': 'PredictorWorkloadBalancing'
        }

        self.attribute_map = {
            'routing_timeout_seconds': 'routingTimeoutSeconds',
            'schedule': 'schedule',
            'workload_balancing_config': 'workloadBalancingConfig'
        }

        self._routing_timeout_seconds = None
        self._schedule = None
        self._workload_balancing_config = None

    @property
    def routing_timeout_seconds(self) -> int:
        """
        Gets the routing_timeout_seconds of this PatchPredictorRequest.
        Number of seconds allocated to predictive routing before attempting a different routing method. This is a value between 12 and 900 seconds.

        :return: The routing_timeout_seconds of this PatchPredictorRequest.
        :rtype: int
        """
        return self._routing_timeout_seconds

    @routing_timeout_seconds.setter
    def routing_timeout_seconds(self, routing_timeout_seconds: int) -> None:
        """
        Sets the routing_timeout_seconds of this PatchPredictorRequest.
        Number of seconds allocated to predictive routing before attempting a different routing method. This is a value between 12 and 900 seconds.

        :param routing_timeout_seconds: The routing_timeout_seconds of this PatchPredictorRequest.
        :type: int
        """
        

        self._routing_timeout_seconds = routing_timeout_seconds

    @property
    def schedule(self) -> 'PredictorSchedule':
        """
        Gets the schedule of this PatchPredictorRequest.
        The predictor schedule that determines when the predictor is used for routing interactions.

        :return: The schedule of this PatchPredictorRequest.
        :rtype: PredictorSchedule
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule: 'PredictorSchedule') -> None:
        """
        Sets the schedule of this PatchPredictorRequest.
        The predictor schedule that determines when the predictor is used for routing interactions.

        :param schedule: The schedule of this PatchPredictorRequest.
        :type: PredictorSchedule
        """
        

        self._schedule = schedule

    @property
    def workload_balancing_config(self) -> 'PredictorWorkloadBalancing':
        """
        Gets the workload_balancing_config of this PatchPredictorRequest.
        The predictor balancing configuration to enable workload balancing

        :return: The workload_balancing_config of this PatchPredictorRequest.
        :rtype: PredictorWorkloadBalancing
        """
        return self._workload_balancing_config

    @workload_balancing_config.setter
    def workload_balancing_config(self, workload_balancing_config: 'PredictorWorkloadBalancing') -> None:
        """
        Sets the workload_balancing_config of this PatchPredictorRequest.
        The predictor balancing configuration to enable workload balancing

        :param workload_balancing_config: The workload_balancing_config of this PatchPredictorRequest.
        :type: PredictorWorkloadBalancing
        """
        

        self._workload_balancing_config = workload_balancing_config

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

