# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Activation
    from . import EventCondition
    from . import OutcomePercentileCondition
    from . import OutcomeProbabilityCondition
    from . import OutcomeQuantileCondition
    from . import PatchAction
    from . import PatchActionMapScheduleGroups
    from . import UrlCondition

class PatchActionMap(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PatchActionMap - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'version': 'int',
            'is_active': 'bool',
            'display_name': 'str',
            'trigger_with_segments': 'list[str]',
            'trigger_with_event_conditions': 'list[EventCondition]',
            'trigger_with_outcome_probability_conditions': 'list[OutcomeProbabilityCondition]',
            'trigger_with_outcome_percentile_conditions': 'list[OutcomePercentileCondition]',
            'trigger_with_outcome_quantile_conditions': 'list[OutcomeQuantileCondition]',
            'page_url_conditions': 'list[UrlCondition]',
            'activation': 'Activation',
            'weight': 'int',
            'action': 'PatchAction',
            'action_map_schedule_groups': 'PatchActionMapScheduleGroups',
            'ignore_frequency_cap': 'bool',
            'self_uri': 'str',
            'created_date': 'datetime',
            'modified_date': 'datetime',
            'start_date': 'datetime',
            'end_date': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'version': 'version',
            'is_active': 'isActive',
            'display_name': 'displayName',
            'trigger_with_segments': 'triggerWithSegments',
            'trigger_with_event_conditions': 'triggerWithEventConditions',
            'trigger_with_outcome_probability_conditions': 'triggerWithOutcomeProbabilityConditions',
            'trigger_with_outcome_percentile_conditions': 'triggerWithOutcomePercentileConditions',
            'trigger_with_outcome_quantile_conditions': 'triggerWithOutcomeQuantileConditions',
            'page_url_conditions': 'pageUrlConditions',
            'activation': 'activation',
            'weight': 'weight',
            'action': 'action',
            'action_map_schedule_groups': 'actionMapScheduleGroups',
            'ignore_frequency_cap': 'ignoreFrequencyCap',
            'self_uri': 'selfUri',
            'created_date': 'createdDate',
            'modified_date': 'modifiedDate',
            'start_date': 'startDate',
            'end_date': 'endDate'
        }

        self._id = None
        self._version = None
        self._is_active = None
        self._display_name = None
        self._trigger_with_segments = None
        self._trigger_with_event_conditions = None
        self._trigger_with_outcome_probability_conditions = None
        self._trigger_with_outcome_percentile_conditions = None
        self._trigger_with_outcome_quantile_conditions = None
        self._page_url_conditions = None
        self._activation = None
        self._weight = None
        self._action = None
        self._action_map_schedule_groups = None
        self._ignore_frequency_cap = None
        self._self_uri = None
        self._created_date = None
        self._modified_date = None
        self._start_date = None
        self._end_date = None

    @property
    def id(self) -> str:
        """
        Gets the id of this PatchActionMap.
        The globally unique identifier for the object.

        :return: The id of this PatchActionMap.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this PatchActionMap.
        The globally unique identifier for the object.

        :param id: The id of this PatchActionMap.
        :type: str
        """
        

        self._id = id

    @property
    def version(self) -> int:
        """
        Gets the version of this PatchActionMap.
        The version of the action map.

        :return: The version of this PatchActionMap.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this PatchActionMap.
        The version of the action map.

        :param version: The version of this PatchActionMap.
        :type: int
        """
        

        self._version = version

    @property
    def is_active(self) -> bool:
        """
        Gets the is_active of this PatchActionMap.
        Whether the action map is active.

        :return: The is_active of this PatchActionMap.
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active: bool) -> None:
        """
        Sets the is_active of this PatchActionMap.
        Whether the action map is active.

        :param is_active: The is_active of this PatchActionMap.
        :type: bool
        """
        

        self._is_active = is_active

    @property
    def display_name(self) -> str:
        """
        Gets the display_name of this PatchActionMap.
        Display name of the action map.

        :return: The display_name of this PatchActionMap.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name: str) -> None:
        """
        Sets the display_name of this PatchActionMap.
        Display name of the action map.

        :param display_name: The display_name of this PatchActionMap.
        :type: str
        """
        

        self._display_name = display_name

    @property
    def trigger_with_segments(self) -> List[str]:
        """
        Gets the trigger_with_segments of this PatchActionMap.
        Trigger action map if any segment in the list is assigned to a given customer.

        :return: The trigger_with_segments of this PatchActionMap.
        :rtype: list[str]
        """
        return self._trigger_with_segments

    @trigger_with_segments.setter
    def trigger_with_segments(self, trigger_with_segments: List[str]) -> None:
        """
        Sets the trigger_with_segments of this PatchActionMap.
        Trigger action map if any segment in the list is assigned to a given customer.

        :param trigger_with_segments: The trigger_with_segments of this PatchActionMap.
        :type: list[str]
        """
        

        self._trigger_with_segments = trigger_with_segments

    @property
    def trigger_with_event_conditions(self) -> List['EventCondition']:
        """
        Gets the trigger_with_event_conditions of this PatchActionMap.
        List of event conditions that must be satisfied to trigger the action map.

        :return: The trigger_with_event_conditions of this PatchActionMap.
        :rtype: list[EventCondition]
        """
        return self._trigger_with_event_conditions

    @trigger_with_event_conditions.setter
    def trigger_with_event_conditions(self, trigger_with_event_conditions: List['EventCondition']) -> None:
        """
        Sets the trigger_with_event_conditions of this PatchActionMap.
        List of event conditions that must be satisfied to trigger the action map.

        :param trigger_with_event_conditions: The trigger_with_event_conditions of this PatchActionMap.
        :type: list[EventCondition]
        """
        

        self._trigger_with_event_conditions = trigger_with_event_conditions

    @property
    def trigger_with_outcome_probability_conditions(self) -> List['OutcomeProbabilityCondition']:
        """
        Gets the trigger_with_outcome_probability_conditions of this PatchActionMap.
        (deprecated - use triggerWithOutcomeQuantileConditions instead) Probability conditions for outcomes that must be satisfied to trigger the action map.

        :return: The trigger_with_outcome_probability_conditions of this PatchActionMap.
        :rtype: list[OutcomeProbabilityCondition]
        """
        return self._trigger_with_outcome_probability_conditions

    @trigger_with_outcome_probability_conditions.setter
    def trigger_with_outcome_probability_conditions(self, trigger_with_outcome_probability_conditions: List['OutcomeProbabilityCondition']) -> None:
        """
        Sets the trigger_with_outcome_probability_conditions of this PatchActionMap.
        (deprecated - use triggerWithOutcomeQuantileConditions instead) Probability conditions for outcomes that must be satisfied to trigger the action map.

        :param trigger_with_outcome_probability_conditions: The trigger_with_outcome_probability_conditions of this PatchActionMap.
        :type: list[OutcomeProbabilityCondition]
        """
        

        self._trigger_with_outcome_probability_conditions = trigger_with_outcome_probability_conditions

    @property
    def trigger_with_outcome_percentile_conditions(self) -> List['OutcomePercentileCondition']:
        """
        Gets the trigger_with_outcome_percentile_conditions of this PatchActionMap.
        (deprecated - use triggerWithOutcomeQuantileConditions instead) Percentile conditions for outcomes that must be satisfied to trigger the action map.

        :return: The trigger_with_outcome_percentile_conditions of this PatchActionMap.
        :rtype: list[OutcomePercentileCondition]
        """
        return self._trigger_with_outcome_percentile_conditions

    @trigger_with_outcome_percentile_conditions.setter
    def trigger_with_outcome_percentile_conditions(self, trigger_with_outcome_percentile_conditions: List['OutcomePercentileCondition']) -> None:
        """
        Sets the trigger_with_outcome_percentile_conditions of this PatchActionMap.
        (deprecated - use triggerWithOutcomeQuantileConditions instead) Percentile conditions for outcomes that must be satisfied to trigger the action map.

        :param trigger_with_outcome_percentile_conditions: The trigger_with_outcome_percentile_conditions of this PatchActionMap.
        :type: list[OutcomePercentileCondition]
        """
        

        self._trigger_with_outcome_percentile_conditions = trigger_with_outcome_percentile_conditions

    @property
    def trigger_with_outcome_quantile_conditions(self) -> List['OutcomeQuantileCondition']:
        """
        Gets the trigger_with_outcome_quantile_conditions of this PatchActionMap.
        Quantile conditions for outcomes that must be satisfied to trigger the action map.

        :return: The trigger_with_outcome_quantile_conditions of this PatchActionMap.
        :rtype: list[OutcomeQuantileCondition]
        """
        return self._trigger_with_outcome_quantile_conditions

    @trigger_with_outcome_quantile_conditions.setter
    def trigger_with_outcome_quantile_conditions(self, trigger_with_outcome_quantile_conditions: List['OutcomeQuantileCondition']) -> None:
        """
        Sets the trigger_with_outcome_quantile_conditions of this PatchActionMap.
        Quantile conditions for outcomes that must be satisfied to trigger the action map.

        :param trigger_with_outcome_quantile_conditions: The trigger_with_outcome_quantile_conditions of this PatchActionMap.
        :type: list[OutcomeQuantileCondition]
        """
        

        self._trigger_with_outcome_quantile_conditions = trigger_with_outcome_quantile_conditions

    @property
    def page_url_conditions(self) -> List['UrlCondition']:
        """
        Gets the page_url_conditions of this PatchActionMap.
        URL conditions that a page must match for web actions to be displayable.

        :return: The page_url_conditions of this PatchActionMap.
        :rtype: list[UrlCondition]
        """
        return self._page_url_conditions

    @page_url_conditions.setter
    def page_url_conditions(self, page_url_conditions: List['UrlCondition']) -> None:
        """
        Sets the page_url_conditions of this PatchActionMap.
        URL conditions that a page must match for web actions to be displayable.

        :param page_url_conditions: The page_url_conditions of this PatchActionMap.
        :type: list[UrlCondition]
        """
        

        self._page_url_conditions = page_url_conditions

    @property
    def activation(self) -> 'Activation':
        """
        Gets the activation of this PatchActionMap.
        Type of activation.

        :return: The activation of this PatchActionMap.
        :rtype: Activation
        """
        return self._activation

    @activation.setter
    def activation(self, activation: 'Activation') -> None:
        """
        Sets the activation of this PatchActionMap.
        Type of activation.

        :param activation: The activation of this PatchActionMap.
        :type: Activation
        """
        

        self._activation = activation

    @property
    def weight(self) -> int:
        """
        Gets the weight of this PatchActionMap.
        Weight of the action map with higher number denoting higher weight.

        :return: The weight of this PatchActionMap.
        :rtype: int
        """
        return self._weight

    @weight.setter
    def weight(self, weight: int) -> None:
        """
        Sets the weight of this PatchActionMap.
        Weight of the action map with higher number denoting higher weight.

        :param weight: The weight of this PatchActionMap.
        :type: int
        """
        

        self._weight = weight

    @property
    def action(self) -> 'PatchAction':
        """
        Gets the action of this PatchActionMap.
        The action that will be executed if this action map is triggered.

        :return: The action of this PatchActionMap.
        :rtype: PatchAction
        """
        return self._action

    @action.setter
    def action(self, action: 'PatchAction') -> None:
        """
        Sets the action of this PatchActionMap.
        The action that will be executed if this action map is triggered.

        :param action: The action of this PatchActionMap.
        :type: PatchAction
        """
        

        self._action = action

    @property
    def action_map_schedule_groups(self) -> 'PatchActionMapScheduleGroups':
        """
        Gets the action_map_schedule_groups of this PatchActionMap.
        The action map's associated schedule groups.

        :return: The action_map_schedule_groups of this PatchActionMap.
        :rtype: PatchActionMapScheduleGroups
        """
        return self._action_map_schedule_groups

    @action_map_schedule_groups.setter
    def action_map_schedule_groups(self, action_map_schedule_groups: 'PatchActionMapScheduleGroups') -> None:
        """
        Sets the action_map_schedule_groups of this PatchActionMap.
        The action map's associated schedule groups.

        :param action_map_schedule_groups: The action_map_schedule_groups of this PatchActionMap.
        :type: PatchActionMapScheduleGroups
        """
        

        self._action_map_schedule_groups = action_map_schedule_groups

    @property
    def ignore_frequency_cap(self) -> bool:
        """
        Gets the ignore_frequency_cap of this PatchActionMap.
        Override organization-level frequency cap and always offer web engagements from this action map.

        :return: The ignore_frequency_cap of this PatchActionMap.
        :rtype: bool
        """
        return self._ignore_frequency_cap

    @ignore_frequency_cap.setter
    def ignore_frequency_cap(self, ignore_frequency_cap: bool) -> None:
        """
        Sets the ignore_frequency_cap of this PatchActionMap.
        Override organization-level frequency cap and always offer web engagements from this action map.

        :param ignore_frequency_cap: The ignore_frequency_cap of this PatchActionMap.
        :type: bool
        """
        

        self._ignore_frequency_cap = ignore_frequency_cap

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this PatchActionMap.
        The URI for this object

        :return: The self_uri of this PatchActionMap.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this PatchActionMap.
        The URI for this object

        :param self_uri: The self_uri of this PatchActionMap.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this PatchActionMap.
        Timestamp indicating when the action map was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The created_date of this PatchActionMap.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this PatchActionMap.
        Timestamp indicating when the action map was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param created_date: The created_date of this PatchActionMap.
        :type: datetime
        """
        

        self._created_date = created_date

    @property
    def modified_date(self) -> datetime:
        """
        Gets the modified_date of this PatchActionMap.
        Timestamp indicating when the action map was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The modified_date of this PatchActionMap.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date: datetime) -> None:
        """
        Sets the modified_date of this PatchActionMap.
        Timestamp indicating when the action map was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param modified_date: The modified_date of this PatchActionMap.
        :type: datetime
        """
        

        self._modified_date = modified_date

    @property
    def start_date(self) -> datetime:
        """
        Gets the start_date of this PatchActionMap.
        Timestamp at which the action map is scheduled to start firing. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_date of this PatchActionMap.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date: datetime) -> None:
        """
        Sets the start_date of this PatchActionMap.
        Timestamp at which the action map is scheduled to start firing. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_date: The start_date of this PatchActionMap.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def end_date(self) -> datetime:
        """
        Gets the end_date of this PatchActionMap.
        Timestamp at which the action map is scheduled to stop firing. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The end_date of this PatchActionMap.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date: datetime) -> None:
        """
        Sets the end_date of this PatchActionMap.
        Timestamp at which the action map is scheduled to stop firing. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param end_date: The end_date of this PatchActionMap.
        :type: datetime
        """
        

        self._end_date = end_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

