# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class OutcomeAttributionJobStateResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutcomeAttributionJobStateResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'state': 'str',
            'results_uri': 'str',
            'percent_failed_threshold': 'int',
            'self_uri': 'str',
            'created_date': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'state': 'state',
            'results_uri': 'resultsUri',
            'percent_failed_threshold': 'percentFailedThreshold',
            'self_uri': 'selfUri',
            'created_date': 'createdDate'
        }

        self._id = None
        self._state = None
        self._results_uri = None
        self._percent_failed_threshold = None
        self._self_uri = None
        self._created_date = None

    @property
    def id(self) -> str:
        """
        Gets the id of this OutcomeAttributionJobStateResponse.
        The globally unique identifier for the object.

        :return: The id of this OutcomeAttributionJobStateResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this OutcomeAttributionJobStateResponse.
        The globally unique identifier for the object.

        :param id: The id of this OutcomeAttributionJobStateResponse.
        :type: str
        """
        

        self._id = id

    @property
    def state(self) -> str:
        """
        Gets the state of this OutcomeAttributionJobStateResponse.
        State of job.

        :return: The state of this OutcomeAttributionJobStateResponse.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this OutcomeAttributionJobStateResponse.
        State of job.

        :param state: The state of this OutcomeAttributionJobStateResponse.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Running", "Completed", "CompletedWithErrors", "Failed"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def results_uri(self) -> str:
        """
        Gets the results_uri of this OutcomeAttributionJobStateResponse.
        URI where the query results can be retrieved.  Populated when job has reached a terminal state, i.e. no longer Running.

        :return: The results_uri of this OutcomeAttributionJobStateResponse.
        :rtype: str
        """
        return self._results_uri

    @results_uri.setter
    def results_uri(self, results_uri: str) -> None:
        """
        Sets the results_uri of this OutcomeAttributionJobStateResponse.
        URI where the query results can be retrieved.  Populated when job has reached a terminal state, i.e. no longer Running.

        :param results_uri: The results_uri of this OutcomeAttributionJobStateResponse.
        :type: str
        """
        

        self._results_uri = results_uri

    @property
    def percent_failed_threshold(self) -> int:
        """
        Gets the percent_failed_threshold of this OutcomeAttributionJobStateResponse.
        Optional percent failed threshold for validation errors; if reached will halt the job. Default is 5 percent, allowed values 0 to 100.

        :return: The percent_failed_threshold of this OutcomeAttributionJobStateResponse.
        :rtype: int
        """
        return self._percent_failed_threshold

    @percent_failed_threshold.setter
    def percent_failed_threshold(self, percent_failed_threshold: int) -> None:
        """
        Sets the percent_failed_threshold of this OutcomeAttributionJobStateResponse.
        Optional percent failed threshold for validation errors; if reached will halt the job. Default is 5 percent, allowed values 0 to 100.

        :param percent_failed_threshold: The percent_failed_threshold of this OutcomeAttributionJobStateResponse.
        :type: int
        """
        

        self._percent_failed_threshold = percent_failed_threshold

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this OutcomeAttributionJobStateResponse.
        The URI for this object

        :return: The self_uri of this OutcomeAttributionJobStateResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this OutcomeAttributionJobStateResponse.
        The URI for this object

        :param self_uri: The self_uri of this OutcomeAttributionJobStateResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this OutcomeAttributionJobStateResponse.
        Date when the job was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The created_date of this OutcomeAttributionJobStateResponse.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this OutcomeAttributionJobStateResponse.
        Date when the job was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param created_date: The created_date of this OutcomeAttributionJobStateResponse.
        :type: datetime
        """
        

        self._created_date = created_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

