# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OutboundMessagingWhatsappCampaignConfigChangeContactSort
    from . import OutboundMessagingWhatsappCampaignConfigChangeEmailConfig
    from . import OutboundMessagingWhatsappCampaignConfigChangeErrorDetail
    from . import OutboundMessagingWhatsappCampaignConfigChangeSmsConfig
    from . import OutboundMessagingWhatsappCampaignConfigChangeUriReference
    from . import OutboundMessagingWhatsappCampaignConfigChangeWhatsAppConfig

class OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'campaign_status': 'str',
            'callable_time_set': 'OutboundMessagingWhatsappCampaignConfigChangeUriReference',
            'contact_list': 'OutboundMessagingWhatsappCampaignConfigChangeUriReference',
            'dnc_lists': 'list[OutboundMessagingWhatsappCampaignConfigChangeUriReference]',
            'contact_list_filters': 'list[OutboundMessagingWhatsappCampaignConfigChangeUriReference]',
            'always_running': 'bool',
            'contact_sorts': 'list[OutboundMessagingWhatsappCampaignConfigChangeContactSort]',
            'messages_per_minute': 'int',
            'rule_sets': 'list[OutboundMessagingWhatsappCampaignConfigChangeUriReference]',
            'sms_config': 'OutboundMessagingWhatsappCampaignConfigChangeSmsConfig',
            'email_config': 'OutboundMessagingWhatsappCampaignConfigChangeEmailConfig',
            'whats_app_config': 'OutboundMessagingWhatsappCampaignConfigChangeWhatsAppConfig',
            'errors': 'list[OutboundMessagingWhatsappCampaignConfigChangeErrorDetail]',
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'division': 'OutboundMessagingWhatsappCampaignConfigChangeUriReference'
        }

        self.attribute_map = {
            'campaign_status': 'campaignStatus',
            'callable_time_set': 'callableTimeSet',
            'contact_list': 'contactList',
            'dnc_lists': 'dncLists',
            'contact_list_filters': 'contactListFilters',
            'always_running': 'alwaysRunning',
            'contact_sorts': 'contactSorts',
            'messages_per_minute': 'messagesPerMinute',
            'rule_sets': 'ruleSets',
            'sms_config': 'smsConfig',
            'email_config': 'emailConfig',
            'whats_app_config': 'whatsAppConfig',
            'errors': 'errors',
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'division': 'division'
        }

        self._campaign_status = None
        self._callable_time_set = None
        self._contact_list = None
        self._dnc_lists = None
        self._contact_list_filters = None
        self._always_running = None
        self._contact_sorts = None
        self._messages_per_minute = None
        self._rule_sets = None
        self._sms_config = None
        self._email_config = None
        self._whats_app_config = None
        self._errors = None
        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._division = None

    @property
    def campaign_status(self) -> str:
        """
        Gets the campaign_status of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :return: The campaign_status of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: str
        """
        return self._campaign_status

    @campaign_status.setter
    def campaign_status(self, campaign_status: str) -> None:
        """
        Sets the campaign_status of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :param campaign_status: The campaign_status of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: str
        """
        if isinstance(campaign_status, int):
            campaign_status = str(campaign_status)
        allowed_values = ["on", "off", "complete", "stopping", "invalid"]
        if campaign_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for campaign_status -> " + campaign_status)
            self._campaign_status = "outdated_sdk_version"
        else:
            self._campaign_status = campaign_status

    @property
    def callable_time_set(self) -> 'OutboundMessagingWhatsappCampaignConfigChangeUriReference':
        """
        Gets the callable_time_set of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :return: The callable_time_set of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingWhatsappCampaignConfigChangeUriReference
        """
        return self._callable_time_set

    @callable_time_set.setter
    def callable_time_set(self, callable_time_set: 'OutboundMessagingWhatsappCampaignConfigChangeUriReference') -> None:
        """
        Sets the callable_time_set of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :param callable_time_set: The callable_time_set of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingWhatsappCampaignConfigChangeUriReference
        """
        

        self._callable_time_set = callable_time_set

    @property
    def contact_list(self) -> 'OutboundMessagingWhatsappCampaignConfigChangeUriReference':
        """
        Gets the contact_list of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        A UriReference for a resource

        :return: The contact_list of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingWhatsappCampaignConfigChangeUriReference
        """
        return self._contact_list

    @contact_list.setter
    def contact_list(self, contact_list: 'OutboundMessagingWhatsappCampaignConfigChangeUriReference') -> None:
        """
        Sets the contact_list of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        A UriReference for a resource

        :param contact_list: The contact_list of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingWhatsappCampaignConfigChangeUriReference
        """
        

        self._contact_list = contact_list

    @property
    def dnc_lists(self) -> List['OutboundMessagingWhatsappCampaignConfigChangeUriReference']:
        """
        Gets the dnc_lists of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        The dnc lists to check before sending a message for this messaging campaign.

        :return: The dnc_lists of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingWhatsappCampaignConfigChangeUriReference]
        """
        return self._dnc_lists

    @dnc_lists.setter
    def dnc_lists(self, dnc_lists: List['OutboundMessagingWhatsappCampaignConfigChangeUriReference']) -> None:
        """
        Sets the dnc_lists of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        The dnc lists to check before sending a message for this messaging campaign.

        :param dnc_lists: The dnc_lists of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingWhatsappCampaignConfigChangeUriReference]
        """
        

        self._dnc_lists = dnc_lists

    @property
    def contact_list_filters(self) -> List['OutboundMessagingWhatsappCampaignConfigChangeUriReference']:
        """
        Gets the contact_list_filters of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        The contact list filters to check before sending a message for this messaging campaign.

        :return: The contact_list_filters of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingWhatsappCampaignConfigChangeUriReference]
        """
        return self._contact_list_filters

    @contact_list_filters.setter
    def contact_list_filters(self, contact_list_filters: List['OutboundMessagingWhatsappCampaignConfigChangeUriReference']) -> None:
        """
        Sets the contact_list_filters of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        The contact list filters to check before sending a message for this messaging campaign.

        :param contact_list_filters: The contact_list_filters of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingWhatsappCampaignConfigChangeUriReference]
        """
        

        self._contact_list_filters = contact_list_filters

    @property
    def always_running(self) -> bool:
        """
        Gets the always_running of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        Whether this messaging campaign is always running.

        :return: The always_running of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: bool
        """
        return self._always_running

    @always_running.setter
    def always_running(self, always_running: bool) -> None:
        """
        Sets the always_running of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        Whether this messaging campaign is always running.

        :param always_running: The always_running of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: bool
        """
        

        self._always_running = always_running

    @property
    def contact_sorts(self) -> List['OutboundMessagingWhatsappCampaignConfigChangeContactSort']:
        """
        Gets the contact_sorts of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        The order in which to sort contacts for dialing, based on up to four columns.

        :return: The contact_sorts of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingWhatsappCampaignConfigChangeContactSort]
        """
        return self._contact_sorts

    @contact_sorts.setter
    def contact_sorts(self, contact_sorts: List['OutboundMessagingWhatsappCampaignConfigChangeContactSort']) -> None:
        """
        Sets the contact_sorts of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        The order in which to sort contacts for dialing, based on up to four columns.

        :param contact_sorts: The contact_sorts of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingWhatsappCampaignConfigChangeContactSort]
        """
        

        self._contact_sorts = contact_sorts

    @property
    def messages_per_minute(self) -> int:
        """
        Gets the messages_per_minute of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        How many messages this messaging campaign will send per minute.

        :return: The messages_per_minute of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: int
        """
        return self._messages_per_minute

    @messages_per_minute.setter
    def messages_per_minute(self, messages_per_minute: int) -> None:
        """
        Sets the messages_per_minute of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        How many messages this messaging campaign will send per minute.

        :param messages_per_minute: The messages_per_minute of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: int
        """
        

        self._messages_per_minute = messages_per_minute

    @property
    def rule_sets(self) -> List['OutboundMessagingWhatsappCampaignConfigChangeUriReference']:
        """
        Gets the rule_sets of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :return: The rule_sets of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingWhatsappCampaignConfigChangeUriReference]
        """
        return self._rule_sets

    @rule_sets.setter
    def rule_sets(self, rule_sets: List['OutboundMessagingWhatsappCampaignConfigChangeUriReference']) -> None:
        """
        Sets the rule_sets of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :param rule_sets: The rule_sets of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingWhatsappCampaignConfigChangeUriReference]
        """
        

        self._rule_sets = rule_sets

    @property
    def sms_config(self) -> 'OutboundMessagingWhatsappCampaignConfigChangeSmsConfig':
        """
        Gets the sms_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :return: The sms_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingWhatsappCampaignConfigChangeSmsConfig
        """
        return self._sms_config

    @sms_config.setter
    def sms_config(self, sms_config: 'OutboundMessagingWhatsappCampaignConfigChangeSmsConfig') -> None:
        """
        Sets the sms_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :param sms_config: The sms_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingWhatsappCampaignConfigChangeSmsConfig
        """
        

        self._sms_config = sms_config

    @property
    def email_config(self) -> 'OutboundMessagingWhatsappCampaignConfigChangeEmailConfig':
        """
        Gets the email_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :return: The email_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingWhatsappCampaignConfigChangeEmailConfig
        """
        return self._email_config

    @email_config.setter
    def email_config(self, email_config: 'OutboundMessagingWhatsappCampaignConfigChangeEmailConfig') -> None:
        """
        Sets the email_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :param email_config: The email_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingWhatsappCampaignConfigChangeEmailConfig
        """
        

        self._email_config = email_config

    @property
    def whats_app_config(self) -> 'OutboundMessagingWhatsappCampaignConfigChangeWhatsAppConfig':
        """
        Gets the whats_app_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :return: The whats_app_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingWhatsappCampaignConfigChangeWhatsAppConfig
        """
        return self._whats_app_config

    @whats_app_config.setter
    def whats_app_config(self, whats_app_config: 'OutboundMessagingWhatsappCampaignConfigChangeWhatsAppConfig') -> None:
        """
        Sets the whats_app_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.


        :param whats_app_config: The whats_app_config of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingWhatsappCampaignConfigChangeWhatsAppConfig
        """
        

        self._whats_app_config = whats_app_config

    @property
    def errors(self) -> List['OutboundMessagingWhatsappCampaignConfigChangeErrorDetail']:
        """
        Gets the errors of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        A list of current error conditions associated with this messaging campaign

        :return: The errors of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingWhatsappCampaignConfigChangeErrorDetail]
        """
        return self._errors

    @errors.setter
    def errors(self, errors: List['OutboundMessagingWhatsappCampaignConfigChangeErrorDetail']) -> None:
        """
        Sets the errors of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        A list of current error conditions associated with this messaging campaign

        :param errors: The errors of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingWhatsappCampaignConfigChangeErrorDetail]
        """
        

        self._errors = errors

    @property
    def id(self) -> str:
        """
        Gets the id of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        The globally unique identifier for the object.

        :return: The id of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        The globally unique identifier for the object.

        :param id: The id of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        The UI-visible name of the object

        :return: The name of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        The UI-visible name of the object

        :param name: The name of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        Creation time of the entity

        :return: The date_created of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        Creation time of the entity

        :param date_created: The date_created of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        Last modified time of the entity

        :return: The date_modified of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        Last modified time of the entity

        :param date_modified: The date_modified of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self) -> int:
        """
        Gets the version of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        Required for updates, must match the version number of the most recent update

        :return: The version of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        Required for updates, must match the version number of the most recent update

        :param version: The version of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: int
        """
        

        self._version = version

    @property
    def division(self) -> 'OutboundMessagingWhatsappCampaignConfigChangeUriReference':
        """
        Gets the division of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        A UriReference for a resource

        :return: The division of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingWhatsappCampaignConfigChangeUriReference
        """
        return self._division

    @division.setter
    def division(self, division: 'OutboundMessagingWhatsappCampaignConfigChangeUriReference') -> None:
        """
        Sets the division of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        A UriReference for a resource

        :param division: The division of this OutboundMessagingWhatsappCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingWhatsappCampaignConfigChangeUriReference
        """
        

        self._division = division

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

