# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OutboundMessagingMessagingCampaignConfigChangeIntegrationRef
    from . import OutboundMessagingMessagingCampaignConfigChangeResponseRef

class OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'whats_app_columns': 'list[str]',
            'integration': 'OutboundMessagingMessagingCampaignConfigChangeIntegrationRef',
            'content_template': 'OutboundMessagingMessagingCampaignConfigChangeResponseRef'
        }

        self.attribute_map = {
            'whats_app_columns': 'whatsAppColumns',
            'integration': 'integration',
            'content_template': 'contentTemplate'
        }

        self._whats_app_columns = None
        self._integration = None
        self._content_template = None

    @property
    def whats_app_columns(self) -> List[str]:
        """
        Gets the whats_app_columns of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.
        The Contact List columns specifying the phone number to send a message to.

        :return: The whats_app_columns of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.
        :rtype: list[str]
        """
        return self._whats_app_columns

    @whats_app_columns.setter
    def whats_app_columns(self, whats_app_columns: List[str]) -> None:
        """
        Sets the whats_app_columns of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.
        The Contact List columns specifying the phone number to send a message to.

        :param whats_app_columns: The whats_app_columns of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.
        :type: list[str]
        """
        

        self._whats_app_columns = whats_app_columns

    @property
    def integration(self) -> 'OutboundMessagingMessagingCampaignConfigChangeIntegrationRef':
        """
        Gets the integration of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.


        :return: The integration of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.
        :rtype: OutboundMessagingMessagingCampaignConfigChangeIntegrationRef
        """
        return self._integration

    @integration.setter
    def integration(self, integration: 'OutboundMessagingMessagingCampaignConfigChangeIntegrationRef') -> None:
        """
        Sets the integration of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.


        :param integration: The integration of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.
        :type: OutboundMessagingMessagingCampaignConfigChangeIntegrationRef
        """
        

        self._integration = integration

    @property
    def content_template(self) -> 'OutboundMessagingMessagingCampaignConfigChangeResponseRef':
        """
        Gets the content_template of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.
        A reference for a Response

        :return: The content_template of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.
        :rtype: OutboundMessagingMessagingCampaignConfigChangeResponseRef
        """
        return self._content_template

    @content_template.setter
    def content_template(self, content_template: 'OutboundMessagingMessagingCampaignConfigChangeResponseRef') -> None:
        """
        Sets the content_template of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.
        A reference for a Response

        :param content_template: The content_template of this OutboundMessagingMessagingCampaignConfigChangeWhatsAppConfig.
        :type: OutboundMessagingMessagingCampaignConfigChangeResponseRef
        """
        

        self._content_template = content_template

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

