# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'contact_phone_number': 'str',
            'contact_phone_number_column_name': 'str',
            'configured_sender_phone_number': 'str',
            'sender_phone_number': 'str'
        }

        self.attribute_map = {
            'contact_phone_number': 'contactPhoneNumber',
            'contact_phone_number_column_name': 'contactPhoneNumberColumnName',
            'configured_sender_phone_number': 'configuredSenderPhoneNumber',
            'sender_phone_number': 'senderPhoneNumber'
        }

        self._contact_phone_number = None
        self._contact_phone_number_column_name = None
        self._configured_sender_phone_number = None
        self._sender_phone_number = None

    @property
    def contact_phone_number(self) -> str:
        """
        Gets the contact_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.


        :return: The contact_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.
        :rtype: str
        """
        return self._contact_phone_number

    @contact_phone_number.setter
    def contact_phone_number(self, contact_phone_number: str) -> None:
        """
        Sets the contact_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.


        :param contact_phone_number: The contact_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.
        :type: str
        """
        

        self._contact_phone_number = contact_phone_number

    @property
    def contact_phone_number_column_name(self) -> str:
        """
        Gets the contact_phone_number_column_name of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.


        :return: The contact_phone_number_column_name of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.
        :rtype: str
        """
        return self._contact_phone_number_column_name

    @contact_phone_number_column_name.setter
    def contact_phone_number_column_name(self, contact_phone_number_column_name: str) -> None:
        """
        Sets the contact_phone_number_column_name of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.


        :param contact_phone_number_column_name: The contact_phone_number_column_name of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.
        :type: str
        """
        

        self._contact_phone_number_column_name = contact_phone_number_column_name

    @property
    def configured_sender_phone_number(self) -> str:
        """
        Gets the configured_sender_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.


        :return: The configured_sender_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.
        :rtype: str
        """
        return self._configured_sender_phone_number

    @configured_sender_phone_number.setter
    def configured_sender_phone_number(self, configured_sender_phone_number: str) -> None:
        """
        Sets the configured_sender_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.


        :param configured_sender_phone_number: The configured_sender_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.
        :type: str
        """
        

        self._configured_sender_phone_number = configured_sender_phone_number

    @property
    def sender_phone_number(self) -> str:
        """
        Gets the sender_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.


        :return: The sender_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.
        :rtype: str
        """
        return self._sender_phone_number

    @sender_phone_number.setter
    def sender_phone_number(self, sender_phone_number: str) -> None:
        """
        Sets the sender_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.


        :param sender_phone_number: The sender_phone_number of this OutboundMessagingCampaignPreContactSmsEventTopicSMSAttributes.
        :type: str
        """
        

        self._sender_phone_number = sender_phone_number

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

