# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import PasswordRequirements

class OrgAuthSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OrgAuthSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'multifactor_authentication_required': 'bool',
            'domain_allowlist_enabled': 'bool',
            'domain_allowlist': 'list[str]',
            'ip_address_allowlist': 'list[str]',
            'password_requirements': 'PasswordRequirements',
            'inactivity_timeout_exclusions': 'list[str]'
        }

        self.attribute_map = {
            'multifactor_authentication_required': 'multifactorAuthenticationRequired',
            'domain_allowlist_enabled': 'domainAllowlistEnabled',
            'domain_allowlist': 'domainAllowlist',
            'ip_address_allowlist': 'ipAddressAllowlist',
            'password_requirements': 'passwordRequirements',
            'inactivity_timeout_exclusions': 'inactivityTimeoutExclusions'
        }

        self._multifactor_authentication_required = None
        self._domain_allowlist_enabled = None
        self._domain_allowlist = None
        self._ip_address_allowlist = None
        self._password_requirements = None
        self._inactivity_timeout_exclusions = None

    @property
    def multifactor_authentication_required(self) -> bool:
        """
        Gets the multifactor_authentication_required of this OrgAuthSettings.
        Indicates whether multi-factor authentication is required.

        :return: The multifactor_authentication_required of this OrgAuthSettings.
        :rtype: bool
        """
        return self._multifactor_authentication_required

    @multifactor_authentication_required.setter
    def multifactor_authentication_required(self, multifactor_authentication_required: bool) -> None:
        """
        Sets the multifactor_authentication_required of this OrgAuthSettings.
        Indicates whether multi-factor authentication is required.

        :param multifactor_authentication_required: The multifactor_authentication_required of this OrgAuthSettings.
        :type: bool
        """
        

        self._multifactor_authentication_required = multifactor_authentication_required

    @property
    def domain_allowlist_enabled(self) -> bool:
        """
        Gets the domain_allowlist_enabled of this OrgAuthSettings.
        Indicates whether the domain allowlist is enabled.

        :return: The domain_allowlist_enabled of this OrgAuthSettings.
        :rtype: bool
        """
        return self._domain_allowlist_enabled

    @domain_allowlist_enabled.setter
    def domain_allowlist_enabled(self, domain_allowlist_enabled: bool) -> None:
        """
        Sets the domain_allowlist_enabled of this OrgAuthSettings.
        Indicates whether the domain allowlist is enabled.

        :param domain_allowlist_enabled: The domain_allowlist_enabled of this OrgAuthSettings.
        :type: bool
        """
        

        self._domain_allowlist_enabled = domain_allowlist_enabled

    @property
    def domain_allowlist(self) -> List[str]:
        """
        Gets the domain_allowlist of this OrgAuthSettings.
        The list of domains that will be allowed to embed Genesys Cloud applications.

        :return: The domain_allowlist of this OrgAuthSettings.
        :rtype: list[str]
        """
        return self._domain_allowlist

    @domain_allowlist.setter
    def domain_allowlist(self, domain_allowlist: List[str]) -> None:
        """
        Sets the domain_allowlist of this OrgAuthSettings.
        The list of domains that will be allowed to embed Genesys Cloud applications.

        :param domain_allowlist: The domain_allowlist of this OrgAuthSettings.
        :type: list[str]
        """
        

        self._domain_allowlist = domain_allowlist

    @property
    def ip_address_allowlist(self) -> List[str]:
        """
        Gets the ip_address_allowlist of this OrgAuthSettings.
        The list of IP addresses that will be allowed to authenticate with Genesys Cloud.

        :return: The ip_address_allowlist of this OrgAuthSettings.
        :rtype: list[str]
        """
        return self._ip_address_allowlist

    @ip_address_allowlist.setter
    def ip_address_allowlist(self, ip_address_allowlist: List[str]) -> None:
        """
        Sets the ip_address_allowlist of this OrgAuthSettings.
        The list of IP addresses that will be allowed to authenticate with Genesys Cloud.

        :param ip_address_allowlist: The ip_address_allowlist of this OrgAuthSettings.
        :type: list[str]
        """
        

        self._ip_address_allowlist = ip_address_allowlist

    @property
    def password_requirements(self) -> 'PasswordRequirements':
        """
        Gets the password_requirements of this OrgAuthSettings.
        The password requirements for the organization.

        :return: The password_requirements of this OrgAuthSettings.
        :rtype: PasswordRequirements
        """
        return self._password_requirements

    @password_requirements.setter
    def password_requirements(self, password_requirements: 'PasswordRequirements') -> None:
        """
        Sets the password_requirements of this OrgAuthSettings.
        The password requirements for the organization.

        :param password_requirements: The password_requirements of this OrgAuthSettings.
        :type: PasswordRequirements
        """
        

        self._password_requirements = password_requirements

    @property
    def inactivity_timeout_exclusions(self) -> List[str]:
        """
        Gets the inactivity_timeout_exclusions of this OrgAuthSettings.
        The list of exempt apis from inactivity timeout.

        :return: The inactivity_timeout_exclusions of this OrgAuthSettings.
        :rtype: list[str]
        """
        return self._inactivity_timeout_exclusions

    @inactivity_timeout_exclusions.setter
    def inactivity_timeout_exclusions(self, inactivity_timeout_exclusions: List[str]) -> None:
        """
        Sets the inactivity_timeout_exclusions of this OrgAuthSettings.
        The list of exempt apis from inactivity timeout.

        :param inactivity_timeout_exclusions: The inactivity_timeout_exclusions of this OrgAuthSettings.
        :type: list[str]
        """
        

        self._inactivity_timeout_exclusions = inactivity_timeout_exclusions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

