# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class OperationalEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OperationalEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_definition': 'AddressableEntityRef',
            'entity_id': 'str',
            'entity_token': 'str',
            'entity_name': 'str',
            'previous_value': 'str',
            'current_value': 'str',
            'error_code': 'str',
            'parent_entity_id': 'str',
            'conversation': 'AddressableEntityRef',
            'date_created': 'datetime',
            'entity_version': 'str'
        }

        self.attribute_map = {
            'event_definition': 'eventDefinition',
            'entity_id': 'entityId',
            'entity_token': 'entityToken',
            'entity_name': 'entityName',
            'previous_value': 'previousValue',
            'current_value': 'currentValue',
            'error_code': 'errorCode',
            'parent_entity_id': 'parentEntityId',
            'conversation': 'conversation',
            'date_created': 'dateCreated',
            'entity_version': 'entityVersion'
        }

        self._event_definition = None
        self._entity_id = None
        self._entity_token = None
        self._entity_name = None
        self._previous_value = None
        self._current_value = None
        self._error_code = None
        self._parent_entity_id = None
        self._conversation = None
        self._date_created = None
        self._entity_version = None

    @property
    def event_definition(self) -> 'AddressableEntityRef':
        """
        Gets the event_definition of this OperationalEvent.
        The event that occurred.

        :return: The event_definition of this OperationalEvent.
        :rtype: AddressableEntityRef
        """
        return self._event_definition

    @event_definition.setter
    def event_definition(self, event_definition: 'AddressableEntityRef') -> None:
        """
        Sets the event_definition of this OperationalEvent.
        The event that occurred.

        :param event_definition: The event_definition of this OperationalEvent.
        :type: AddressableEntityRef
        """
        

        self._event_definition = event_definition

    @property
    def entity_id(self) -> str:
        """
        Gets the entity_id of this OperationalEvent.
        The unique identifier for the entity

        :return: The entity_id of this OperationalEvent.
        :rtype: str
        """
        return self._entity_id

    @entity_id.setter
    def entity_id(self, entity_id: str) -> None:
        """
        Sets the entity_id of this OperationalEvent.
        The unique identifier for the entity

        :param entity_id: The entity_id of this OperationalEvent.
        :type: str
        """
        

        self._entity_id = entity_id

    @property
    def entity_token(self) -> str:
        """
        Gets the entity_token of this OperationalEvent.
        A token representing the entity

        :return: The entity_token of this OperationalEvent.
        :rtype: str
        """
        return self._entity_token

    @entity_token.setter
    def entity_token(self, entity_token: str) -> None:
        """
        Sets the entity_token of this OperationalEvent.
        A token representing the entity

        :param entity_token: The entity_token of this OperationalEvent.
        :type: str
        """
        

        self._entity_token = entity_token

    @property
    def entity_name(self) -> str:
        """
        Gets the entity_name of this OperationalEvent.
        The name for the entity

        :return: The entity_name of this OperationalEvent.
        :rtype: str
        """
        return self._entity_name

    @entity_name.setter
    def entity_name(self, entity_name: str) -> None:
        """
        Sets the entity_name of this OperationalEvent.
        The name for the entity

        :param entity_name: The entity_name of this OperationalEvent.
        :type: str
        """
        

        self._entity_name = entity_name

    @property
    def previous_value(self) -> str:
        """
        Gets the previous_value of this OperationalEvent.
        The value prior to the event

        :return: The previous_value of this OperationalEvent.
        :rtype: str
        """
        return self._previous_value

    @previous_value.setter
    def previous_value(self, previous_value: str) -> None:
        """
        Sets the previous_value of this OperationalEvent.
        The value prior to the event

        :param previous_value: The previous_value of this OperationalEvent.
        :type: str
        """
        

        self._previous_value = previous_value

    @property
    def current_value(self) -> str:
        """
        Gets the current_value of this OperationalEvent.
        The changed value following the event

        :return: The current_value of this OperationalEvent.
        :rtype: str
        """
        return self._current_value

    @current_value.setter
    def current_value(self, current_value: str) -> None:
        """
        Sets the current_value of this OperationalEvent.
        The changed value following the event

        :param current_value: The current_value of this OperationalEvent.
        :type: str
        """
        

        self._current_value = current_value

    @property
    def error_code(self) -> str:
        """
        Gets the error_code of this OperationalEvent.
        The error code of the entity in the providing service associated to the event

        :return: The error_code of this OperationalEvent.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code: str) -> None:
        """
        Sets the error_code of this OperationalEvent.
        The error code of the entity in the providing service associated to the event

        :param error_code: The error_code of this OperationalEvent.
        :type: str
        """
        

        self._error_code = error_code

    @property
    def parent_entity_id(self) -> str:
        """
        Gets the parent_entity_id of this OperationalEvent.
        The unique identifier for the parent of the entity

        :return: The parent_entity_id of this OperationalEvent.
        :rtype: str
        """
        return self._parent_entity_id

    @parent_entity_id.setter
    def parent_entity_id(self, parent_entity_id: str) -> None:
        """
        Sets the parent_entity_id of this OperationalEvent.
        The unique identifier for the parent of the entity

        :param parent_entity_id: The parent_entity_id of this OperationalEvent.
        :type: str
        """
        

        self._parent_entity_id = parent_entity_id

    @property
    def conversation(self) -> 'AddressableEntityRef':
        """
        Gets the conversation of this OperationalEvent.
        The link to a conversation

        :return: The conversation of this OperationalEvent.
        :rtype: AddressableEntityRef
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation: 'AddressableEntityRef') -> None:
        """
        Sets the conversation of this OperationalEvent.
        The link to a conversation

        :param conversation: The conversation of this OperationalEvent.
        :type: AddressableEntityRef
        """
        

        self._conversation = conversation

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this OperationalEvent.
        The date when the event created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this OperationalEvent.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this OperationalEvent.
        The date when the event created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this OperationalEvent.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def entity_version(self) -> str:
        """
        Gets the entity_version of this OperationalEvent.
        The version of the entity in the providing service

        :return: The entity_version of this OperationalEvent.
        :rtype: str
        """
        return self._entity_version

    @entity_version.setter
    def entity_version(self, entity_version: str) -> None:
        """
        Sets the entity_version of this OperationalEvent.
        The version of the entity in the providing service

        :param entity_version: The entity_version of this OperationalEvent.
        :type: str
        """
        

        self._entity_version = entity_version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

