# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import InfixOperator
    from . import OperandPosition
    from . import Term

class Operand(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Operand - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'occurrence': 'int',
            'inverted': 'bool',
            'term': 'Term',
            'topic_id': 'str',
            'voice_seconds_position': 'OperandPosition',
            'digital_words_position': 'OperandPosition',
            'infix_operator': 'InfixOperator',
            'operands': 'list[Operand]'
        }

        self.attribute_map = {
            'type': 'type',
            'occurrence': 'occurrence',
            'inverted': 'inverted',
            'term': 'term',
            'topic_id': 'topicId',
            'voice_seconds_position': 'voiceSecondsPosition',
            'digital_words_position': 'digitalWordsPosition',
            'infix_operator': 'infixOperator',
            'operands': 'operands'
        }

        self._type = None
        self._occurrence = None
        self._inverted = None
        self._term = None
        self._topic_id = None
        self._voice_seconds_position = None
        self._digital_words_position = None
        self._infix_operator = None
        self._operands = None

    @property
    def type(self) -> str:
        """
        Gets the type of this Operand.
        The Operand type of the category

        :return: The type of this Operand.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this Operand.
        The Operand type of the category

        :param type: The type of this Operand.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Term", "Topic", "OperandGroup"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def occurrence(self) -> int:
        """
        Gets the occurrence of this Operand.
        The minimum number of occurrences of the defined operand type

        :return: The occurrence of this Operand.
        :rtype: int
        """
        return self._occurrence

    @occurrence.setter
    def occurrence(self, occurrence: int) -> None:
        """
        Sets the occurrence of this Operand.
        The minimum number of occurrences of the defined operand type

        :param occurrence: The occurrence of this Operand.
        :type: int
        """
        

        self._occurrence = occurrence

    @property
    def inverted(self) -> bool:
        """
        Gets the inverted of this Operand.
        Applies a NOT modifier to the operand group

        :return: The inverted of this Operand.
        :rtype: bool
        """
        return self._inverted

    @inverted.setter
    def inverted(self, inverted: bool) -> None:
        """
        Sets the inverted of this Operand.
        Applies a NOT modifier to the operand group

        :param inverted: The inverted of this Operand.
        :type: bool
        """
        

        self._inverted = inverted

    @property
    def term(self) -> 'Term':
        """
        Gets the term of this Operand.
        Filter interaction by word(s)

        :return: The term of this Operand.
        :rtype: Term
        """
        return self._term

    @term.setter
    def term(self, term: 'Term') -> None:
        """
        Sets the term of this Operand.
        Filter interaction by word(s)

        :param term: The term of this Operand.
        :type: Term
        """
        

        self._term = term

    @property
    def topic_id(self) -> str:
        """
        Gets the topic_id of this Operand.
        Filter interaction by topic ID

        :return: The topic_id of this Operand.
        :rtype: str
        """
        return self._topic_id

    @topic_id.setter
    def topic_id(self, topic_id: str) -> None:
        """
        Sets the topic_id of this Operand.
        Filter interaction by topic ID

        :param topic_id: The topic_id of this Operand.
        :type: str
        """
        

        self._topic_id = topic_id

    @property
    def voice_seconds_position(self) -> 'OperandPosition':
        """
        Gets the voice_seconds_position of this Operand.
        Dictates when the operand must occur in a voice interaction

        :return: The voice_seconds_position of this Operand.
        :rtype: OperandPosition
        """
        return self._voice_seconds_position

    @voice_seconds_position.setter
    def voice_seconds_position(self, voice_seconds_position: 'OperandPosition') -> None:
        """
        Sets the voice_seconds_position of this Operand.
        Dictates when the operand must occur in a voice interaction

        :param voice_seconds_position: The voice_seconds_position of this Operand.
        :type: OperandPosition
        """
        

        self._voice_seconds_position = voice_seconds_position

    @property
    def digital_words_position(self) -> 'OperandPosition':
        """
        Gets the digital_words_position of this Operand.
        Dictates when the operand must occur in a digital interaction

        :return: The digital_words_position of this Operand.
        :rtype: OperandPosition
        """
        return self._digital_words_position

    @digital_words_position.setter
    def digital_words_position(self, digital_words_position: 'OperandPosition') -> None:
        """
        Sets the digital_words_position of this Operand.
        Dictates when the operand must occur in a digital interaction

        :param digital_words_position: The digital_words_position of this Operand.
        :type: OperandPosition
        """
        

        self._digital_words_position = digital_words_position

    @property
    def infix_operator(self) -> 'InfixOperator':
        """
        Gets the infix_operator of this Operand.
        Defines a logical operation that is applied on the current operand, against the following operand

        :return: The infix_operator of this Operand.
        :rtype: InfixOperator
        """
        return self._infix_operator

    @infix_operator.setter
    def infix_operator(self, infix_operator: 'InfixOperator') -> None:
        """
        Sets the infix_operator of this Operand.
        Defines a logical operation that is applied on the current operand, against the following operand

        :param infix_operator: The infix_operator of this Operand.
        :type: InfixOperator
        """
        

        self._infix_operator = infix_operator

    @property
    def operands(self) -> List['Operand']:
        """
        Gets the operands of this Operand.
        Contains a new level of operands

        :return: The operands of this Operand.
        :rtype: list[Operand]
        """
        return self._operands

    @operands.setter
    def operands(self, operands: List['Operand']) -> None:
        """
        Sets the operands of this Operand.
        Contains a new level of operands

        :param operands: The operands of this Operand.
        :type: list[Operand]
        """
        

        self._operands = operands

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

